/*
 * Decompiled with CFR 0.152.
 */
package net.librec.eval.fairness;

import com.google.common.collect.BiMap;
import java.util.List;
import net.librec.eval.AbstractRecommenderEvaluator;
import net.librec.math.structure.SequentialAccessSparseMatrix;
import net.librec.recommender.item.KeyValue;
import net.librec.recommender.item.RecommendedList;
import org.apache.commons.lang.StringUtils;

public class NonParityUnfairnessEvaluator
extends AbstractRecommenderEvaluator {
    protected SequentialAccessSparseMatrix userFeatureMatrix;
    protected double nonParityUnfairness;

    @Override
    public double evaluate(RecommendedList groundTruthList, RecommendedList recommendedList) {
        if (groundTruthList == null) {
            return 0.0;
        }
        String protectedAttr = "";
        if (this.conf != null && StringUtils.isNotBlank(this.conf.get("data.protected.feature"))) {
            protectedAttr = this.conf.get("data.protected.feature");
        }
        this.userFeatureMatrix = this.getDataModel().getFeatureAppender().getUserFeatures();
        BiMap<String, Integer> featureIdMapping = this.getDataModel().getFeatureAppender().getUserFeatureMap();
        int numUsers = this.userFeatureMatrix.rowSize();
        int numFeatures = this.userFeatureMatrix.columnSize();
        this.nonParityUnfairness = 0.0;
        int numUsersPro = 0;
        int numUsersUnpro = 0;
        double predictedRatingPro = 0.0;
        double predictedRatingUnpro = 0.0;
        for (int userID = 0; userID < numUsers; ++userID) {
            boolean protectedOrNot = false;
            for (int featureId = 0; featureId < numFeatures; ++featureId) {
                if (this.userFeatureMatrix.get(userID, featureId) != 1.0) continue;
                if (featureId == (Integer)featureIdMapping.get(protectedAttr)) {
                    protectedOrNot = true;
                    ++numUsersPro;
                    continue;
                }
                protectedOrNot = false;
                ++numUsersUnpro;
            }
            double userAvgPredictedRating = 0.0;
            List<KeyValue<Integer, Double>> recommendListByUser = recommendedList.getKeyValueListByContext(userID);
            int topK = this.topN <= recommendListByUser.size() ? this.topN : recommendListByUser.size();
            for (int indexOfItem = 0; indexOfItem < topK; ++indexOfItem) {
                int itemId = recommendListByUser.get(indexOfItem).getKey();
                double ratingPredicted = recommendListByUser.get(indexOfItem).getValue();
                userAvgPredictedRating += ratingPredicted;
            }
            userAvgPredictedRating /= (double)topK;
            if (protectedOrNot) {
                predictedRatingPro += userAvgPredictedRating;
                continue;
            }
            predictedRatingUnpro += userAvgPredictedRating;
        }
        this.nonParityUnfairness = Math.abs((predictedRatingPro /= (double)numUsersPro) - (predictedRatingUnpro /= (double)numUsersUnpro));
        return this.nonParityUnfairness;
    }
}

