/*
 * Decompiled with CFR 0.152.
 */
package net.librec.eval.fairness;

import com.google.common.collect.BiMap;
import java.util.List;
import java.util.Set;
import net.librec.data.DataModel;
import net.librec.eval.AbstractRecommenderEvaluator;
import net.librec.math.structure.SequentialAccessSparseMatrix;
import net.librec.recommender.item.KeyValue;
import net.librec.recommender.item.RecommendedList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PStatisticalParityEvaluator
extends AbstractRecommenderEvaluator {
    protected final Log LOG = LogFactory.getLog(this.getClass());
    protected SequentialAccessSparseMatrix itemFeatureMatrix;

    @Override
    public void setDataModel(DataModel datamodel) {
        super.setDataModel(datamodel);
    }

    @Override
    public double evaluate(RecommendedList groundTruthList, RecommendedList recommendedList) {
        this.itemFeatureMatrix = this.getDataModel().getFeatureAppender().getItemFeatures();
        BiMap<String, Integer> featureIdMapping = this.getDataModel().getFeatureAppender().getItemFeatureMap();
        BiMap<String, Integer> itemIdMapping = this.getDataModel().getItemMappingData();
        double totalProtected = 0.0;
        double totalUnprotected = 0.0;
        int numUsers = groundTruthList.size();
        int numItems = this.itemFeatureMatrix.rowSize();
        int numFeatures = this.itemFeatureMatrix.columnSize();
        String protectedAttribute = this.conf.get("data.protected.feature");
        if (this.conf != null && StringUtils.isNotBlank(this.conf.get("data.protected.feature"))) {
            protectedAttribute = this.conf.get("data.protected.feature");
        }
        double protectedSize = 0.0;
        double unprotectedSize = 0.0;
        int proAttId = (Integer)featureIdMapping.get(protectedAttribute);
        for (int itemId = 0; itemId < numItems; ++itemId) {
            if (this.itemFeatureMatrix.get(itemId, proAttId) == 1.0) {
                protectedSize += 1.0;
                continue;
            }
            unprotectedSize += 1.0;
        }
        double nonZeroUsers = 0.0;
        for (int userID = 0; userID < numUsers; ++userID) {
            Set<Integer> testSetByUser = groundTruthList.getKeySetByContext(userID);
            if (testSetByUser.size() <= 0) continue;
            int unprotectedNum = 0;
            int protectedNum = 0;
            List<KeyValue<Integer, Double>> recommendListByUser = recommendedList.getKeyValueListByContext(userID);
            int topK = this.topN <= recommendListByUser.size() ? this.topN : recommendListByUser.size();
            for (int indexOfItem = 0; indexOfItem < topK; ++indexOfItem) {
                int itemID = recommendListByUser.get(indexOfItem).getKey();
                if (this.itemFeatureMatrix.get(itemID, proAttId) == 1.0) {
                    ++protectedNum;
                    continue;
                }
                ++unprotectedNum;
            }
            totalProtected += (double)protectedNum / (double)topK;
            totalUnprotected += (double)unprotectedNum / (double)topK;
            nonZeroUsers += 1.0;
        }
        double protectedRatio = totalProtected / nonZeroUsers;
        double unprotectedRatio = totalUnprotected / nonZeroUsers;
        return protectedRatio - unprotectedRatio;
    }
}

