/*
 * Decompiled with CFR 0.152.
 */
package net.librec.eval.fairness;

import com.google.common.collect.BiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.librec.eval.AbstractRecommenderEvaluator;
import net.librec.math.structure.SequentialAccessSparseMatrix;
import net.librec.recommender.item.KeyValue;
import net.librec.recommender.item.RecommendedList;
import org.apache.commons.lang.StringUtils;

public class UnderestimationUnfairnessEvaluator
extends AbstractRecommenderEvaluator {
    protected SequentialAccessSparseMatrix userFeatureMatrix;
    protected double underEstimationUnfairness;

    @Override
    public double evaluate(RecommendedList groundTruthList, RecommendedList recommendedList) {
        if (groundTruthList == null) {
            return 0.0;
        }
        String protectedAttr = "";
        if (this.conf != null && StringUtils.isNotBlank(this.conf.get("data.protected.feature"))) {
            protectedAttr = this.conf.get("data.protected.feature");
        }
        this.userFeatureMatrix = this.getDataModel().getFeatureAppender().getUserFeatures();
        BiMap<String, Integer> featureIdMapping = this.getDataModel().getFeatureAppender().getUserFeatureMap();
        int numItems = this.getDataModel().getItemMappingData().size();
        int numUsers = this.userFeatureMatrix.rowSize();
        int numFeatures = this.userFeatureMatrix.columnSize();
        ArrayList<Double> testItemRatingSumByProUsers = new ArrayList<Double>(Collections.nCopies(numItems, 0.0));
        ArrayList<Double> testProUsersCounter = new ArrayList<Double>(Collections.nCopies(numItems, 1.0));
        ArrayList<Double> testItemRatingSumByUnproUsers = new ArrayList<Double>(Collections.nCopies(numItems, 0.0));
        ArrayList<Double> testUnproUsersCounter = new ArrayList<Double>(Collections.nCopies(numItems, 1.0));
        ArrayList<Double> recItemRatingSumByProUsers = new ArrayList<Double>(Collections.nCopies(numItems, 0.0));
        ArrayList<Double> recProUsersCounter = new ArrayList<Double>(Collections.nCopies(numItems, 1.0));
        ArrayList<Double> recItemRatingSumByUnproUsers = new ArrayList<Double>(Collections.nCopies(numItems, 0.0));
        ArrayList<Double> recUnproUsersCounter = new ArrayList<Double>(Collections.nCopies(numItems, 1.0));
        for (int userID = 0; userID < numUsers; ++userID) {
            boolean isProtected = false;
            for (int featureId = 0; featureId < numFeatures; ++featureId) {
                if (this.userFeatureMatrix.get(userID, featureId) != 1.0) continue;
                isProtected = featureId == (Integer)featureIdMapping.get(protectedAttr);
            }
            List<KeyValue<Integer, Double>> testListByUser = groundTruthList.getKeyValueListByContext(userID);
            if (testListByUser.size() <= 0) continue;
            for (int indexOfItem = 0; indexOfItem < testListByUser.size(); ++indexOfItem) {
                int itemId = testListByUser.get(indexOfItem).getKey();
                double ratingActual = testListByUser.get(indexOfItem).getValue();
                if (isProtected) {
                    testItemRatingSumByProUsers.set(itemId, (Double)testItemRatingSumByProUsers.get(itemId) + ratingActual);
                    testProUsersCounter.set(itemId, (Double)testProUsersCounter.get(itemId) + 1.0);
                    continue;
                }
                testItemRatingSumByUnproUsers.set(itemId, (Double)testItemRatingSumByUnproUsers.get(itemId) + ratingActual);
                testUnproUsersCounter.set(itemId, (Double)testUnproUsersCounter.get(itemId) + 1.0);
            }
            List<KeyValue<Integer, Double>> recommendListByUser = recommendedList.getKeyValueListByContext(userID);
            int topK = this.topN <= recommendListByUser.size() ? this.topN : recommendListByUser.size();
            for (int indexOfItem = 0; indexOfItem < topK; ++indexOfItem) {
                int itemId = recommendListByUser.get(indexOfItem).getKey();
                double ratingPredicted = recommendListByUser.get(indexOfItem).getValue();
                if (isProtected) {
                    recItemRatingSumByProUsers.set(itemId, (Double)recItemRatingSumByProUsers.get(itemId) + ratingPredicted);
                    recProUsersCounter.set(itemId, (Double)recProUsersCounter.get(itemId) + 1.0);
                    continue;
                }
                recItemRatingSumByUnproUsers.set(itemId, (Double)recItemRatingSumByUnproUsers.get(itemId) + ratingPredicted);
                recUnproUsersCounter.set(itemId, (Double)recUnproUsersCounter.get(itemId) + 1.0);
            }
        }
        this.underEstimationUnfairness = 0.0;
        double avgRatingPro = 0.0;
        double avgRecPro = 0.0;
        double avgRatingUnpro = 0.0;
        double avgRecUnpro = 0.0;
        for (int indexOfItem = 0; indexOfItem < numItems; ++indexOfItem) {
            avgRecPro = (Double)recItemRatingSumByProUsers.get(indexOfItem) / (Double)recProUsersCounter.get(indexOfItem);
            avgRatingPro = (Double)testItemRatingSumByProUsers.get(indexOfItem) / (Double)testProUsersCounter.get(indexOfItem);
            avgRecUnpro = (Double)recItemRatingSumByUnproUsers.get(indexOfItem) / (Double)recUnproUsersCounter.get(indexOfItem);
            avgRatingUnpro = (Double)testItemRatingSumByUnproUsers.get(indexOfItem) / (Double)testUnproUsersCounter.get(indexOfItem);
            this.underEstimationUnfairness += Math.abs(Math.max(0.0, avgRatingPro - avgRecPro) - Math.max(0.0, avgRatingUnpro - avgRecUnpro));
        }
        this.underEstimationUnfairness /= (double)numItems;
        return this.underEstimationUnfairness;
    }
}

