/*
 * Decompiled with CFR 0.152.
 */
package net.librec.eval.ranking;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.librec.common.LibrecRuntimeException;
import net.librec.eval.AbstractRecommenderEvaluator;
import net.librec.recommender.item.KeyValue;
import net.librec.recommender.item.RecommendedList;

public class AUCEvaluator
extends AbstractRecommenderEvaluator {
    @Override
    public double evaluate(RecommendedList groundTruthList, RecommendedList recommendedList) {
        double auc = 0.0;
        int numContext = groundTruthList.size();
        int nonZeroContext = 0;
        int[] numDroppedArray = this.getConf().getInts("rec.eval.auc.dropped.num");
        if (numDroppedArray == null || numDroppedArray.length != numContext) {
            throw new LibrecRuntimeException("please set rec.eval.auc.dropped.num arrays, length of numDroppedArray must be cardinality of groundTruthList.");
        }
        for (int contextIdx = 0; contextIdx < numContext; ++contextIdx) {
            Set<Integer> groudTruthSetByContext = groundTruthList.getKeySetByContext(contextIdx);
            if (groudTruthSetByContext.size() <= 0) continue;
            ++nonZeroContext;
            List<KeyValue<Integer, Double>> recommendListByContext = recommendedList.getKeyValueListByContext(contextIdx);
            int topK = this.topN <= recommendListByContext.size() ? this.topN : recommendListByContext.size();
            int numDroppedItems = numDroppedArray[contextIdx] - topK;
            HashSet<Integer> recommendSetByContext = new HashSet<Integer>();
            for (int indexOfKey = 0; indexOfKey < topK; ++indexOfKey) {
                recommendSetByContext.add(recommendListByContext.get(indexOfKey).getKey());
            }
            int numRelevantKeys = 0;
            int numMissKeys = 0;
            for (Integer testKey : recommendSetByContext) {
                if (groudTruthSetByContext.contains(testKey)) {
                    ++numRelevantKeys;
                    continue;
                }
                ++numMissKeys;
            }
            int numEvaluatingItems = numDroppedItems + topK;
            int numEvaluatingPairs = (numEvaluatingItems - numRelevantKeys) * numRelevantKeys;
            if (numEvaluatingPairs < 0) {
                throw new IndexOutOfBoundsException("numEvaluatingPairs cannot be less than 0.");
            }
            if (numEvaluatingPairs == 0) {
                auc += 0.5;
                continue;
            }
            int numCorrectPairs = 0;
            int hits = 0;
            for (Integer itemIdx : groudTruthSetByContext) {
                if (!recommendSetByContext.contains(itemIdx)) {
                    numCorrectPairs += hits;
                    continue;
                }
                ++hits;
            }
            auc += ((double)(numCorrectPairs += hits * (numDroppedItems - numMissKeys)) + 0.0) / (double)numEvaluatingPairs;
        }
        return nonZeroContext > 0 ? auc / (double)nonZeroContext : 0.0;
    }
}

