/*
 * Decompiled with CFR 0.152.
 */
package net.librec.eval.ranking;

import java.util.List;
import net.librec.eval.AbstractRecommenderEvaluator;
import net.librec.recommender.item.KeyValue;
import net.librec.recommender.item.RecommendedList;

public class AverageReciprocalHitRankEvaluator
extends AbstractRecommenderEvaluator {
    @Override
    public double evaluate(RecommendedList groundTruthList, RecommendedList recommendedList) {
        double reciprocalRank = 0.0;
        int numContext = groundTruthList.size();
        int nonZeroContext = 0;
        for (int contextIdx = 0; contextIdx < numContext; ++contextIdx) {
            List<KeyValue<Integer, Double>> testListByContext = groundTruthList.getKeyValueListByContext(contextIdx);
            if (testListByContext.size() <= 0) continue;
            List<KeyValue<Integer, Double>> recommendListByContext = recommendedList.getKeyValueListByContext(contextIdx);
            int trueKeyIdx = testListByContext.get(0).getKey();
            int topK = this.topN <= recommendListByContext.size() ? this.topN : recommendListByContext.size();
            for (int indexOfKey = 0; indexOfKey < topK; ++indexOfKey) {
                if (recommendListByContext.get(indexOfKey).getKey() != trueKeyIdx) continue;
                reciprocalRank += 1.0 / ((double)indexOfKey + 1.0);
                break;
            }
            ++nonZeroContext;
        }
        return nonZeroContext > 0 ? reciprocalRank / (double)nonZeroContext : 0.0;
    }
}

