/*
 * Decompiled with CFR 0.152.
 */
package net.librec.eval.ranking;

import java.util.List;
import net.librec.eval.AbstractRecommenderEvaluator;
import net.librec.math.structure.SymmMatrix;
import net.librec.recommender.item.KeyValue;
import net.librec.recommender.item.RecommendedList;
import net.librec.similarity.RecommenderSimilarity;

public class DiversityEvaluator
extends AbstractRecommenderEvaluator {
    @Override
    public double evaluate(RecommendedList groundTruthList, RecommendedList recommendedList) {
        double totalDiversity = 0.0;
        int numContext = groundTruthList.size();
        int nonZeroContext = 0;
        if (this.similarities.containsKey("item")) {
            SymmMatrix itemSimilarity = ((RecommenderSimilarity)this.similarities.get("item")).getSimilarityMatrix();
            for (int contextIdx = 0; contextIdx < numContext; ++contextIdx) {
                List<KeyValue<Integer, Double>> recommendArrayListByContext = recommendedList.getKeyValueListByContext(contextIdx);
                if (recommendArrayListByContext.size() <= 1) continue;
                double totalDisSimilarityPerContext = 0.0;
                int topK = this.topN <= recommendArrayListByContext.size() ? this.topN : recommendArrayListByContext.size();
                for (int indexOut = 0; indexOut < topK; ++indexOut) {
                    for (int indexIn = 0; indexIn < topK; ++indexIn) {
                        if (indexOut == indexIn) continue;
                        int keyOut = recommendArrayListByContext.get(indexOut).getKey();
                        int keyIn = recommendArrayListByContext.get(indexIn).getKey();
                        totalDisSimilarityPerContext += 1.0 - itemSimilarity.get(keyOut, keyIn);
                    }
                }
                totalDiversity += totalDisSimilarityPerContext / (double)(topK * (topK - 1));
                ++nonZeroContext;
            }
        }
        return nonZeroContext > 0 ? totalDiversity / (double)nonZeroContext : 0.0;
    }
}

