/*
 * Decompiled with CFR 0.152.
 */
package net.librec.eval.ranking;

import java.util.List;
import net.librec.eval.AbstractRecommenderEvaluator;
import net.librec.recommender.item.KeyValue;
import net.librec.recommender.item.RecommendedList;

public class EntropyEvaluator
extends AbstractRecommenderEvaluator {
    @Override
    public double evaluate(RecommendedList groundTruthList, RecommendedList recommendedList) {
        int numUsers = groundTruthList.size();
        int numItems = this.conf.getInt("rec.eval.item.num");
        int[] itemCounts = new int[numItems];
        for (int contextIdx = 0; contextIdx < numUsers; ++contextIdx) {
            List<KeyValue<Integer, Double>> recoList = recommendedList.getKeyValueListByContext(contextIdx);
            int topK = this.topN <= recoList.size() ? this.topN : recoList.size();
            for (int recoIdx = 0; recoIdx < topK; ++recoIdx) {
                int n = recoList.get(recoIdx).getKey();
                itemCounts[n] = itemCounts[n] + 1;
            }
        }
        double sumEntropy = 0.0;
        for (int count : itemCounts) {
            if (count <= 0) continue;
            double estmProbability = (double)count / (double)numUsers;
            sumEntropy += estmProbability * -Math.log(estmProbability);
        }
        return sumEntropy / Math.log(2.0);
    }
}

