/*
 * Decompiled with CFR 0.152.
 */
package net.librec.eval.ranking;

import java.util.Arrays;
import java.util.List;
import net.librec.eval.AbstractRecommenderEvaluator;
import net.librec.recommender.item.KeyValue;
import net.librec.recommender.item.RecommendedList;

public class GiniIndexEvaluator
extends AbstractRecommenderEvaluator {
    @Override
    public double evaluate(RecommendedList groundTruthList, RecommendedList recommendedList) {
        int numUsers = groundTruthList.size();
        int numItems = this.conf.getInt("rec.eval.item.num");
        int[] itemCounts = new int[numItems];
        for (int contextIdx = 0; contextIdx < numUsers; ++contextIdx) {
            List<KeyValue<Integer, Double>> recoList = recommendedList.getKeyValueListByContext(contextIdx);
            int topK = this.topN <= recoList.size() ? this.topN : recoList.size();
            for (int recoIdx = 0; recoIdx < topK; ++recoIdx) {
                int n = recoList.get(recoIdx).getKey();
                itemCounts[n] = itemCounts[n] + 1;
            }
        }
        double[] itemProb = new double[numItems];
        for (int index = 0; index < numItems; ++index) {
            double estmProbability;
            int count = itemCounts[index];
            if (count <= 0) continue;
            itemProb[index] = estmProbability = (double)count / (double)Arrays.stream(itemCounts).sum();
        }
        double sumGini = 0.0;
        Arrays.sort(itemProb);
        for (int index = 0; index < numItems; ++index) {
            sumGini += (2.0 * (double)index - (double)numItems + 1.0) * itemProb[index];
        }
        return sumGini /= (double)numItems - 1.0;
    }
}

