/*
 * Decompiled with CFR 0.152.
 */
package net.librec.eval.ranking;

import java.util.List;
import net.librec.eval.AbstractRecommenderEvaluator;
import net.librec.recommender.item.KeyValue;
import net.librec.recommender.item.RecommendedList;

public class HitRateEvaluator
extends AbstractRecommenderEvaluator {
    @Override
    public double evaluate(RecommendedList groundTruthList, RecommendedList recommendedList) {
        if (groundTruthList.size() == 0) {
            return 0.0;
        }
        int totalHits = 0;
        int numContext = groundTruthList.size();
        int nonZeroContext = 0;
        for (int contextIdx = 0; contextIdx < numContext; ++contextIdx) {
            List<KeyValue<Integer, Double>> testListByContext = groundTruthList.getKeyValueListByContext(contextIdx);
            if (testListByContext.size() == 1) {
                int keyTest = testListByContext.get(0).getKey();
                List<KeyValue<Integer, Double>> recommendListByContext = recommendedList.getKeyValueListByContext(contextIdx);
                int topK = this.topN <= recommendListByContext.size() ? this.topN : recommendListByContext.size();
                for (int indexOfKey = 0; indexOfKey < topK; ++indexOfKey) {
                    int keyRec = recommendListByContext.get(indexOfKey).getKey();
                    if (keyRec != keyTest) continue;
                    ++totalHits;
                    break;
                }
                ++nonZeroContext;
                continue;
            }
            if (testListByContext.size() <= 1) continue;
            throw new IndexOutOfBoundsException("It is not a leave-one-out validation method! Please use leave-one-out validation method");
        }
        return nonZeroContext > 0 ? 1.0 * (double)totalHits / (double)nonZeroContext : 0.0;
    }
}

