/*
 * Decompiled with CFR 0.152.
 */
package net.librec.eval.ranking;

import net.librec.eval.AbstractRecommenderEvaluator;
import net.librec.math.algorithm.Maths;
import net.librec.recommender.item.RecommendedList;

public class IdealDCGEvaluator
extends AbstractRecommenderEvaluator {
    @Override
    public double evaluate(RecommendedList groundTruthList, RecommendedList recommendedList) {
        double iDCG = 0.0;
        int numContext = groundTruthList.size();
        int nonZeroContext = 0;
        for (int contextIdx = 0; contextIdx < numContext; ++contextIdx) {
            double idcg = 0.0;
            int sizeByContext = groundTruthList.getKeyValueListByContext(contextIdx).size();
            if (sizeByContext <= 0) continue;
            for (int i = 0; i < sizeByContext; ++i) {
                idcg += 1.0 / Maths.log((double)i + 2.0, 2);
            }
            iDCG += idcg;
            ++nonZeroContext;
        }
        return nonZeroContext > 0 ? iDCG / (double)nonZeroContext : 0.0;
    }
}

