/*
 * Decompiled with CFR 0.152.
 */
package net.librec.eval.ranking;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.librec.eval.AbstractRecommenderEvaluator;
import net.librec.math.structure.SequentialAccessSparseMatrix;
import net.librec.recommender.item.KeyValue;
import net.librec.recommender.item.RecommendedList;

public class ItemCoverageEvaluator
extends AbstractRecommenderEvaluator {
    @Override
    public double evaluate(RecommendedList groundTruthList, RecommendedList recommendedList) {
        if (groundTruthList == null) {
            return 0.0;
        }
        SequentialAccessSparseMatrix trainMatrix = this.dataModel.getDataSplitter().getTrainData();
        HashSet<Integer> uniqueItemsRecList = new HashSet<Integer>();
        HashSet<Integer> uniqueItemsInTestTrainMatrix = new HashSet<Integer>();
        int numUsers = groundTruthList.size();
        for (int contextIdx = 0; contextIdx < numUsers; ++contextIdx) {
            Set<Integer> testSetByContext = groundTruthList.getKeySetByContext(contextIdx);
            int[] trainSetByContext = trainMatrix.row(contextIdx).getIndices();
            if (testSetByContext.size() <= 0) continue;
            Iterator<Integer> iterator = testSetByContext.iterator();
            while (iterator.hasNext()) {
                int itemID = iterator.next();
                if (uniqueItemsInTestTrainMatrix.contains(itemID)) continue;
                uniqueItemsInTestTrainMatrix.add(itemID);
            }
            for (Object itemID : (Iterator<Integer>)trainSetByContext) {
                if (uniqueItemsInTestTrainMatrix.contains((int)itemID)) continue;
                uniqueItemsInTestTrainMatrix.add((int)itemID);
            }
            List<KeyValue<Integer, Double>> recommendListByContext = recommendedList.getKeyValueListByContext(contextIdx);
            int topK = this.topN <= recommendListByContext.size() ? this.topN : recommendListByContext.size();
            for (int indexOfKey = 0; indexOfKey < topK; ++indexOfKey) {
                int itemIdx = recommendListByContext.get(indexOfKey).getKey();
                if (uniqueItemsRecList.contains(itemIdx)) continue;
                uniqueItemsRecList.add(itemIdx);
            }
        }
        return uniqueItemsInTestTrainMatrix.size() > 0 ? (double)uniqueItemsRecList.size() * 1.0 / (double)uniqueItemsInTestTrainMatrix.size() : 0.0;
    }
}

