/*
 * Decompiled with CFR 0.152.
 */
package net.librec.eval.ranking;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.librec.eval.AbstractRecommenderEvaluator;
import net.librec.math.algorithm.Maths;
import net.librec.recommender.item.KeyValue;
import net.librec.recommender.item.RecommendedList;

public class NormalizedDCGEvaluator
extends AbstractRecommenderEvaluator {
    @Override
    public double evaluate(RecommendedList groundTruthList, RecommendedList recommendedList) {
        double nDCG = 0.0;
        int numContext = groundTruthList.size();
        int nonZeroContext = 0;
        for (int contextIdx = 0; contextIdx < numContext; ++contextIdx) {
            Set<Integer> testSetByContext = groundTruthList.getKeySetByContext(contextIdx);
            if (testSetByContext.size() <= 0) continue;
            List<KeyValue<Integer, Double>> groundTruthTestSetByContext = groundTruthList.getKeyValueListByContext(contextIdx);
            List<KeyValue<Integer, Double>> recommendListByContext = recommendedList.getKeyValueListByContext(contextIdx);
            boolean hasdcgsValue = false;
            ArrayList<RankRate> groundTruthTestSet = new ArrayList<RankRate>();
            for (int i = 0; i < groundTruthTestSetByContext.size(); ++i) {
                groundTruthTestSet.add(new RankRate(groundTruthTestSetByContext.get(i).getKey(), groundTruthTestSetByContext.get(i).getValue()));
            }
            double dcg = 0.0;
            int topK = this.topN <= recommendListByContext.size() ? this.topN : recommendListByContext.size();
            for (int indexOfKey = 0; indexOfKey < topK; ++indexOfKey) {
                int itemID = recommendListByContext.get(indexOfKey).getKey();
                if (!testSetByContext.contains(itemID)) continue;
                double rankvalue = this.getValueByKey(groundTruthTestSet, itemID);
                hasdcgsValue = true;
                dcg += rankvalue / Maths.log(indexOfKey + 2, 2);
            }
            if (!hasdcgsValue || dcg == 0.0) {
                ++nonZeroContext;
                continue;
            }
            double idcg = 0.0;
            ArrayList<Double> idcgsValue = new ArrayList<Double>();
            for (int i = 0; i < groundTruthTestSet.size(); ++i) {
                idcgsValue.add(((RankRate)groundTruthTestSet.get(i)).getValue());
            }
            Collections.sort(idcgsValue, Collections.reverseOrder());
            int validIdxNum = topK < idcgsValue.size() ? topK : idcgsValue.size();
            for (int i = 0; i < validIdxNum; ++i) {
                idcg += (Double)idcgsValue.get(i) / Maths.log(i + 2, 2);
            }
            if (idcg == 0.0) {
                ++nonZeroContext;
                continue;
            }
            nDCG += dcg / idcg;
            ++nonZeroContext;
        }
        return nonZeroContext > 0 ? nDCG / (double)nonZeroContext : 0.0;
    }

    public double getValueByKey(List<RankRate> list, int key) {
        for (RankRate keyValue : list) {
            if (key != keyValue.getIndexId()) continue;
            return keyValue.getValue();
        }
        return 0.0;
    }

    public class RankRate {
        int indexId;
        double value;

        public int getIndexId() {
            return this.indexId;
        }

        public void setIndexId(int indexId) {
            this.indexId = indexId;
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
        }

        public RankRate(int indexId, double value) {
            this.setIndexId(indexId);
            this.setValue(value);
        }
    }
}

