/*
 * Decompiled with CFR 0.152.
 */
package net.librec.eval.ranking;

import java.util.List;
import net.librec.eval.AbstractRecommenderEvaluator;
import net.librec.recommender.item.KeyValue;
import net.librec.recommender.item.RecommendedList;

public class NoveltyEvaluator
extends AbstractRecommenderEvaluator {
    @Override
    public double evaluate(RecommendedList groundTruthList, RecommendedList recommendedList) {
        int numUsers = groundTruthList.size();
        int[] itemCounts = this.conf.getInts("rec.eval.item.purchase.num");
        double sumInformation = 0.0;
        for (int contextIdx = 0; contextIdx < numUsers; ++contextIdx) {
            List<KeyValue<Integer, Double>> recoList = recommendedList.getKeyValueListByContext(contextIdx);
            int topK = this.topN <= recoList.size() ? this.topN : recoList.size();
            for (int recoIdx = 0; recoIdx < topK; ++recoIdx) {
                int itemIdx = recoList.get(recoIdx).getKey();
                int count = itemCounts[itemIdx];
                if (count <= 0) continue;
                double estmProbability = (double)count / (double)numUsers;
                double selfInformation = -Math.log(estmProbability);
                sumInformation += selfInformation;
            }
        }
        return sumInformation / ((double)numUsers * Math.log(2.0));
    }
}

