/*
 * Decompiled with CFR 0.152.
 */
package net.librec.eval.ranking;

import java.util.List;
import java.util.Set;
import net.librec.eval.AbstractRecommenderEvaluator;
import net.librec.recommender.item.KeyValue;
import net.librec.recommender.item.RecommendedList;

public class PrecisionEvaluator
extends AbstractRecommenderEvaluator {
    @Override
    public double evaluate(RecommendedList groundTruthList, RecommendedList recommendedList) {
        double totalPrecision = 0.0;
        int numContext = groundTruthList.size();
        int nonZeroContext = 0;
        for (int contextIdx = 0; contextIdx < numContext; ++contextIdx) {
            Set<Integer> testSetByContext = groundTruthList.getKeySetByContext(contextIdx);
            if (testSetByContext.size() <= 0) continue;
            List<KeyValue<Integer, Double>> recommendListByContext = recommendedList.getKeyValueListByContext(contextIdx);
            int numHits = 0;
            int topK = this.topN <= recommendListByContext.size() ? this.topN : recommendListByContext.size();
            for (int indexOfKey = 0; indexOfKey < topK; ++indexOfKey) {
                int key = recommendListByContext.get(indexOfKey).getKey();
                if (!testSetByContext.contains(key)) continue;
                ++numHits;
            }
            totalPrecision += (double)numHits / ((double)this.topN + 0.0);
            ++nonZeroContext;
        }
        return nonZeroContext > 0 ? totalPrecision / (double)nonZeroContext : 0.0;
    }
}

