/*
 * Decompiled with CFR 0.152.
 */
package net.librec.eval.rating;

import java.util.Iterator;
import net.librec.eval.AbstractRecommenderEvaluator;
import net.librec.recommender.item.ContextKeyValueEntry;
import net.librec.recommender.item.RecommendedList;

public class MPEEvaluator
extends AbstractRecommenderEvaluator {
    @Override
    public double evaluate(RecommendedList groundTruthList, RecommendedList recommendedList) {
        if (groundTruthList.size() == 0) {
            return 0.0;
        }
        int mpeNum = 0;
        int testSize = 0;
        double mpe = this.conf.getDouble("rec.measure.mpe", 0.01);
        Iterator<ContextKeyValueEntry> groundTruthIter = groundTruthList.iterator();
        Iterator<ContextKeyValueEntry> recommendedEntryIter = recommendedList.iterator();
        while (groundTruthIter.hasNext()) {
            if (recommendedEntryIter.hasNext()) {
                ContextKeyValueEntry groundEntry = groundTruthIter.next();
                ContextKeyValueEntry recommendedEntry = recommendedEntryIter.next();
                if (groundEntry.getContextIdx() == recommendedEntry.getContextIdx() && groundEntry.getKey() == recommendedEntry.getKey()) {
                    double predictRating;
                    double realRating = groundEntry.getValue();
                    double error = Math.abs(realRating - (predictRating = recommendedEntry.getValue()));
                    if (error > mpe) {
                        ++mpeNum;
                    }
                    ++testSize;
                    continue;
                }
                throw new IndexOutOfBoundsException("index of recommendedList does not equal testMatrix index");
            }
            throw new IndexOutOfBoundsException("index cardinality of recommendedList does not equal testMatrix index cardinality");
        }
        return testSize > 0 ? ((double)mpeNum + 0.0) / (double)testSize : 0.0;
    }
}

