/*
 * Decompiled with CFR 0.152.
 */
package net.librec.filter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.librec.filter.RecommendedFilter;
import net.librec.recommender.item.RecommendedItem;
import org.apache.commons.lang.StringUtils;

public class GenericRecommendedFilter
implements RecommendedFilter {
    private List<String> userIdList;
    private List<String> itemIdList;

    @Override
    public List<RecommendedItem> filter(List<RecommendedItem> recommendedList) {
        if (recommendedList != null && recommendedList.size() > 0 && (this.userIdList != null && this.userIdList.size() > 0 || this.itemIdList != null && this.itemIdList.size() > 0)) {
            HashSet<RecommendedItem> filterRecommendedSet = new HashSet<RecommendedItem>();
            this.filter(this.userIdList, recommendedList, filterRecommendedSet, "user");
            this.filter(this.itemIdList, recommendedList, filterRecommendedSet, "item");
            return new ArrayList<RecommendedItem>(filterRecommendedSet);
        }
        return recommendedList;
    }

    private void filter(List<String> filterIdList, List<RecommendedItem> recommendedList, Set<RecommendedItem> filterRecommendedSet, String filterType) {
        if (filterIdList != null && filterIdList.size() > 0) {
            for (String filterId : filterIdList) {
                for (RecommendedItem recommendedItem : recommendedList) {
                    String recommendedId = null;
                    if (StringUtils.equals("user", filterType)) {
                        recommendedId = recommendedItem.getUserId();
                    } else if (StringUtils.equals("item", filterType)) {
                        recommendedId = recommendedItem.getItemId();
                    }
                    if (!StringUtils.equals(filterId, recommendedId)) continue;
                    filterRecommendedSet.add(recommendedItem);
                }
            }
        }
    }

    public void setUserIdList(List<String> userIdList) {
        this.userIdList = userIdList;
    }

    public void setItemIdList(List<String> itemIdList) {
        this.itemIdList = itemIdList;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.itemIdList == null ? 0 : this.itemIdList.hashCode());
        result = 31 * result + (this.userIdList == null ? 0 : this.userIdList.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericRecommendedFilter other = (GenericRecommendedFilter)obj;
        if (this.itemIdList == null ? other.itemIdList != null : !this.itemIdList.equals(other.itemIdList)) {
            return false;
        }
        return !(this.userIdList == null ? other.userIdList != null : !this.userIdList.equals(other.userIdList));
    }
}

