/*
 * Decompiled with CFR 0.152.
 */
package net.librec.fs;

public class Path
implements Comparable {
    public static final String SEPARATOR = "/";
    private static final String CUR_DIR = "/";
    private String path;

    public Path(String parent, String child) {
        this(new Path(parent), new Path(child));
    }

    public Path(Path parent, String child) {
        this(parent, new Path(child));
    }

    public Path(String parent, Path child) {
        this(new Path(parent), child);
    }

    public Path(Path parent, Path child) {
        if (child.isAbsolute()) {
            this.path = child.path;
        }
        StringBuilder sb = new StringBuilder(parent.path.length() + 1 + child.path.length());
        sb.append(parent.path);
        if (!parent.path.equals("/")) {
            sb.append("/");
        }
        sb.append(child);
        this.path = sb.toString();
    }

    private static boolean isAbsolutePath(String path) {
        return path.startsWith("/");
    }

    private void checkPathArg(String path) throws IllegalArgumentException {
        if (path == null) {
            throw new IllegalArgumentException("Can not create a Path from a null string");
        }
        if (path.length() == 0) {
            throw new IllegalArgumentException("Can not create a Path from an empty string");
        }
    }

    public Path(String pathString) throws IllegalArgumentException {
        this.checkPathArg(pathString);
        this.path = Path.normalizePath(pathString);
    }

    private static String normalizePath(String path) {
        path = path.replaceAll("//", "/");
        int minLength = 1;
        if (path.length() > minLength && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public int depth() {
        int slash;
        int depth = 0;
        int n = slash = this.path.length() == 1 && this.path.charAt(0) == '/' ? -1 : 0;
        while (slash != -1) {
            ++depth;
            slash = this.path.indexOf("/", slash + 1);
        }
        return depth;
    }

    public boolean isAbsolute() {
        return Path.isAbsolutePath(this.path);
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public String getName() {
        int slash = this.path.lastIndexOf("/");
        return this.path.substring(slash + 1);
    }

    public Path getParent() {
        int end;
        int lastSlash = this.path.lastIndexOf(47);
        int start = 0;
        if (this.path.length() == start || lastSlash == start && this.path.length() == start + 1) {
            return null;
        }
        String parent = lastSlash == -1 ? "/" : this.path.substring(0, lastSlash == (end = 0) ? end + 1 : lastSlash);
        return new Path(parent);
    }

    public Path suffix(String suffix) {
        return new Path(this.getParent(), this.getName() + suffix);
    }

    public String toString() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Path)) {
            return false;
        }
        Path that = (Path)o;
        return this.path.equals(that.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public int compareTo(Object o) {
        Path that = (Path)o;
        return this.path.compareTo(that.path);
    }
}

