/*
 * Decompiled with CFR 0.152.
 */
package net.librec.increment;

import net.librec.common.LibrecException;
import net.librec.increment.IncrementalRatingRecommender;
import net.librec.increment.TableMatrix;

public abstract class IncrementalMFRecommender
extends IncrementalRatingRecommender {
    protected double learnRate = 0.01f;
    protected double maxLearnRate;
    protected TableMatrix userFactors;
    protected TableMatrix itemFactors;
    protected int numFactors = 10;
    protected int numIterations;
    protected double initMean;
    protected double initStd;
    protected double regUser;
    protected double regItem;
    public double regularization = 0.015f;
    public double decay = 1.0;
    public int numIter = 2;
    public double initStdDev = 0.1;
    protected double maxRating;
    protected double minRating;
    protected double globalBias;
    protected double currentLearnrate;

    @Override
    protected void setup() throws LibrecException {
        super.setup();
        this.numIterations = this.conf.getInt("rec.iterator.maximum", 100);
        this.learnRate = this.conf.getDouble("rec.iterator.learnrate", 0.01);
        this.maxLearnRate = this.conf.getDouble("rec.iterator.learnrate.maximum", 1000.0);
        this.regUser = this.conf.getDouble("rec.user.regularization", 0.01);
        this.regItem = this.conf.getDouble("rec.item.regularization", 0.01);
        this.numFactors = this.conf.getInt("rec.factor.number", 10);
        this.isBoldDriver = this.conf.getBoolean("rec.learnrate.bolddriver", false);
        this.decay = this.conf.getDouble("rec.learnrate.decay", 1.0);
        this.userFactors = new TableMatrix(this.numUsers, this.numFactors);
        this.itemFactors = new TableMatrix(this.numItems, this.numFactors);
        this.initMean = 0.0;
        this.initStd = 0.1;
        this.userFactors.init(this.initMean, this.initStd);
        this.itemFactors.init(this.initMean, this.initStd);
    }

    protected void initModel() throws LibrecException {
        this.setup();
        this.userFactors = new TableMatrix(this.numUsers, this.numFactors);
        this.itemFactors = new TableMatrix(this.numItems, this.numFactors);
        this.userFactors.init(this.initMean, this.initStd);
        this.itemFactors.init(this.initMean, this.initStd);
        this.currentLearnrate = this.learnRate;
    }

    @Override
    protected double predict(int userIdx, int itemIdx) throws LibrecException {
        return TableMatrix.rowMult(this.userFactors, userIdx, this.itemFactors, itemIdx);
    }

    @Override
    protected void updateLRate(int iter) {
        if (this.currentLearnrate < 0.0) {
            this.lastLoss = this.loss;
            return;
        }
        if (this.isBoldDriver && iter > 1) {
            this.currentLearnrate = Math.abs(this.lastLoss) > Math.abs(this.loss) ? this.currentLearnrate * (double)1.05f : this.currentLearnrate * 0.5;
        } else if (this.decay > 0.0 && this.decay < 1.0) {
            this.currentLearnrate *= this.decay;
        }
        if (this.maxLearnRate > 0.0 && this.currentLearnrate > this.maxLearnRate) {
            this.currentLearnrate = this.maxLearnRate;
        }
        this.lastLoss = this.loss;
    }

    @Override
    public double getRegularization() {
        return this.regularization;
    }

    @Override
    public void setRegularization(double regularization) {
        this.regularization = regularization;
    }

    @Override
    public double getLearnRate() {
        return this.regularization;
    }

    @Override
    public void setLearnRate(double learnRate) {
        this.learnRate = learnRate;
    }

    @Override
    public double getDecay() {
        return this.decay;
    }

    @Override
    public void setDecay(double decay) {
        this.decay = decay;
    }

    @Override
    public double getInitStdDev() {
        return this.initStdDev;
    }

    @Override
    public void setInitStdDev(double initStdDev) {
        this.initStdDev = initStdDev;
    }

    @Override
    public int getNumFactors() {
        return this.numFactors;
    }

    @Override
    public void setNumFactors(int numFactors) {
        this.numFactors = numFactors;
    }

    @Override
    public int getNumIter() {
        return this.numIter;
    }

    @Override
    public void setNumIter(int numIter) {
        this.numIter = numIter;
    }

    @Override
    public double getMaxRating() {
        return this.maxRating;
    }

    @Override
    public void setMaxRating(double maxRating) {
        this.maxRating = maxRating;
    }

    @Override
    public double getMinRating() {
        return this.minRating;
    }

    @Override
    public void setMinRating(double minRating) {
        this.minRating = minRating;
    }

    @Override
    public double getGlobalBias(double globalMean) {
        return globalMean;
    }

    @Override
    protected void setGlobalBias(double globalBias) {
        this.globalBias = globalBias;
    }
}

