/*
 * Decompiled with CFR 0.152.
 */
package net.librec.increment;

import com.google.common.collect.Table;
import java.util.Iterator;
import net.librec.common.LibrecException;
import net.librec.increment.IIncrementalRatingRecommender;
import net.librec.increment.IncrementalRecommender;
import net.librec.increment.TableMatrix;

public abstract class IncrementalRatingRecommender
extends IncrementalRecommender
implements IIncrementalRatingRecommender {
    public boolean updateUsers = true;
    public boolean updateItems = true;
    public double regularization;
    public double learnRate;
    public double decay;
    public int numIter;
    public double initStdDev;
    public int numFactors;
    protected double maxRating;
    protected double minRating;
    protected double globalBias;

    public OptimizationTarget lossTarget(String optTarget) {
        switch (optTarget) {
            case "rmse": {
                return OptimizationTarget.RMSE;
            }
            case "mse": {
                return OptimizationTarget.MSE;
            }
            case "logistic": {
                return OptimizationTarget.LogisticLoss;
            }
        }
        return OptimizationTarget.RMSE;
    }

    public double getRegularization() {
        return this.regularization;
    }

    public void setRegularization(double regularization) {
        this.regularization = regularization;
    }

    public double getLearnRate() {
        return this.regularization;
    }

    public void setLearnRate(double learnRate) {
        this.learnRate = learnRate;
    }

    public double getDecay() {
        return this.decay;
    }

    public void setDecay(double decay) {
        this.decay = decay;
    }

    public double getInitStdDev() {
        return this.initStdDev;
    }

    public void setInitStdDev(double initStdDev) {
        this.initStdDev = initStdDev;
    }

    public int getNumFactors() {
        return this.numFactors;
    }

    public void setNumFactors(int numFactors) {
        this.numFactors = numFactors;
    }

    public int getNumIter() {
        return this.numIter;
    }

    public void setNumIter(int numIter) {
        this.numIter = numIter;
    }

    public double getMaxRating() {
        return this.maxRating;
    }

    public void setMaxRating(double maxRating) {
        this.maxRating = maxRating;
    }

    public double getMinRating() {
        return this.minRating;
    }

    public void setMinRating(double minRating) {
        this.minRating = minRating;
    }

    public double getGlobalBias(double globalMean) {
        double avg = (globalMean - this.minRating) / (this.maxRating - this.minRating);
        this.globalBias = Math.log(avg / (1.0 - avg));
        return this.globalBias;
    }

    protected void setGlobalBias(double globalBias) {
        this.globalBias = globalBias;
    }

    @Override
    public void addRatings(TableMatrix newRatings) throws LibrecException {
        Iterator<Table.Cell<Integer, Integer, Double>> it = newRatings.iterator();
        while (it.hasNext()) {
            Table.Cell<Integer, Integer, Double> ratingData = it.next();
            int userId = ratingData.getRowKey();
            int itemId = ratingData.getColumnKey();
            double ratingValue = ratingData.getValue();
            if (userId > this.maxUserId) {
                this.addUser(userId);
            }
            if (itemId <= this.maxItemId) continue;
            this.addItem(itemId);
        }
    }

    @Override
    public void updateRatings(TableMatrix newRatings) throws LibrecException {
        Iterator<Table.Cell<Integer, Integer, Double>> it = newRatings.iterator();
        while (it.hasNext()) {
            Table.Cell<Integer, Integer, Double> ratingData = it.next();
            int userId = ratingData.getRowKey();
            int itemId = ratingData.getColumnKey();
            double ratingValue = ratingData.getValue();
            if (userId <= this.maxUserId && itemId <= this.maxItemId) continue;
        }
    }

    @Override
    public void removeRatings(TableMatrix removeRatings) throws LibrecException {
        Iterator<Table.Cell<Integer, Integer, Double>> it = removeRatings.iterator();
        while (it.hasNext()) {
            Table.Cell<Integer, Integer, Double> ratingData = it.next();
            int userId = ratingData.getRowKey();
            int itemId = ratingData.getColumnKey();
            if (userId <= this.maxUserId && itemId <= this.maxItemId) continue;
        }
    }

    @Override
    protected void addUser(int userId) {
        if (userId > this.maxUserId) {
            this.maxItemId = userId;
        }
    }

    @Override
    public void removeUser(int userId) {
        if (userId == this.maxUserId) {
            --this.maxUserId;
        }
    }

    @Override
    protected void addItem(int itemId) {
        if (itemId > this.maxItemId) {
            this.maxItemId = itemId;
        }
    }

    @Override
    public void removeItem(int itemId) {
        if (itemId == this.maxItemId) {
            --this.maxItemId;
        }
    }

    public static enum OptimizationTarget {
        RMSE,
        MSE,
        LogisticLoss;

    }
}

