/*
 * Decompiled with CFR 0.152.
 */
package net.librec.increment;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.librec.math.algorithm.Randoms;

public class TableMatrix {
    protected Table<Integer, Integer, Double> table = HashBasedTable.create();
    protected int size;
    protected int rowSize;
    protected int columnSize;

    public TableMatrix() {
    }

    public TableMatrix(int numColmns) {
        this();
        for (int i = 0; i < 1; ++i) {
            for (int j = 0; j < numColmns; ++j) {
                this.table.put(i, j, 0.0);
            }
        }
    }

    public TableMatrix(int numRows2, int numColmns) {
        this();
        for (int i = 0; i < numRows2; ++i) {
            for (int j = 0; j < numColmns; ++j) {
                this.table.put(i, j, 0.0);
            }
        }
    }

    public void init(double initVal) {
        this.rowSize = this.rowSize();
        this.columnSize = this.columnSize();
        for (int i = 0; i < this.rowSize; ++i) {
            for (int j = 0; j < this.columnSize; ++j) {
                this.table.put(i, j, initVal);
            }
        }
    }

    public void init(double mean, double sigma) {
        this.rowSize = this.rowSize();
        this.columnSize = this.columnSize();
        for (int i = 0; i < this.rowSize; ++i) {
            for (int j = 0; j < this.columnSize; ++j) {
                this.table.put(i, j, Randoms.gaussian(mean, sigma));
            }
        }
    }

    public double get(int id) {
        if (this.table.contains(0, id)) {
            double value = this.table.get(0, id);
            return value;
        }
        return -1.0;
    }

    public double get(int userId, int itemId) {
        if (this.table.contains(userId, itemId)) {
            double value = this.table.get(userId, itemId);
            return value;
        }
        return -1.0;
    }

    public double set(int itemId, double value) {
        double previouslyValue = this.table.put(0, itemId, value);
        return previouslyValue;
    }

    public double set(int userId, int itemId, double value) {
        double previouslyValue = this.table.put(userId, itemId, value);
        return previouslyValue;
    }

    public double add(double value) {
        double previouslyValue = this.set(0, this.columnSize(), value);
        return previouslyValue;
    }

    public double add(int id, double value) {
        double previouslyValue = 0.0;
        previouslyValue = this.table.contains(0, id) ? this.set(0, id, this.get(id) + value) : this.set(0, id, value);
        return previouslyValue;
    }

    public double add(int userId, int itemId, double value) {
        double previouslyValue = 0.0;
        previouslyValue = this.table.contains(userId, itemId) ? this.set(userId, itemId, this.get(userId, itemId) + value) : this.set(userId, itemId, value);
        return previouslyValue;
    }

    public double reomve(int userId, int itemId) {
        double previouslyValue = this.table.remove(userId, itemId);
        return previouslyValue;
    }

    public int size() {
        this.size = this.table.size();
        return this.size;
    }

    public int rowSize() {
        int rsize = this.table.rowKeySet().size();
        return rsize;
    }

    public int columnSize() {
        int csize = this.table.columnKeySet().size();
        return csize;
    }

    public Iterator<Table.Cell<Integer, Integer, Double>> iterator() {
        Set<Table.Cell<Integer, Integer, Double>> tableSet = this.table.cellSet();
        Iterator<Table.Cell<Integer, Integer, Double>> it = tableSet.iterator();
        return it;
    }

    public static double inner(List<Double> vec1, List<Double> vec2) {
        assert (vec1.size() == vec2.size());
        double result = 0.0;
        for (int i = 0; i < vec1.size(); ++i) {
            result += vec1.get(i) * vec2.get(i);
        }
        return result;
    }

    public static double rowMult(TableMatrix m, int mrow, TableMatrix n, int nrow) {
        assert (m.columnSize() == n.columnSize());
        int columnSize = m.columnSize();
        double res = 0.0;
        int k = columnSize;
        for (int j = 0; j < k; ++j) {
            res += m.get(mrow, j) * n.get(nrow, j);
        }
        return res;
    }

    public List<Double> row(int rowId) {
        ArrayList<Double> list = new ArrayList<Double>();
        Map<Integer, Double> rowMap = this.table.row(rowId);
        for (Map.Entry<Integer, Double> entry : rowMap.entrySet()) {
            double ratingData = entry.getValue();
            list.add(ratingData);
        }
        return list;
    }

    public List<Double> getColumnVector(int columnId) {
        ArrayList<Double> list = new ArrayList<Double>();
        Map<Integer, Double> columnMap = this.table.column(columnId);
        for (Map.Entry<Integer, Double> entry : columnMap.entrySet()) {
            double ratingData = entry.getValue();
            list.add(ratingData);
        }
        return list;
    }

    private void iterRowMapdata(Map<Integer, Double> mapData) {
        for (Map.Entry<Integer, Double> entry : mapData.entrySet()) {
            int itemId = entry.getKey();
            double d = entry.getValue();
        }
    }

    public void addRow(int rowNum) {
        this.addRow(rowNum, 0.0);
    }

    public void addRow(int rowNum, double initValue) {
        int rSize = this.rowSize();
        int cSize = this.columnSize();
        if (rowNum > rSize) {
            for (int i = 0; i < cSize; ++i) {
                this.set(rSize + 1, i, initValue);
            }
        }
    }

    public void setRowToOneValue(int rowId, double value) {
        int cSize = this.columnSize();
        for (int i = 0; i < cSize; ++i) {
            this.set(rowId, i, value);
        }
    }
}

