/*
 * Decompiled with CFR 0.152.
 */
package net.librec.job;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.librec.common.LibrecException;
import net.librec.conf.Configuration;
import net.librec.data.DataModel;
import net.librec.data.DataSplitter;
import net.librec.data.splitter.KCVDataSplitter;
import net.librec.data.splitter.LOOCVDataSplitter;
import net.librec.eval.EvalContext;
import net.librec.eval.Measure;
import net.librec.eval.RecommenderEvaluator;
import net.librec.filter.RecommendedFilter;
import net.librec.math.algorithm.Randoms;
import net.librec.math.structure.DataSet;
import net.librec.math.structure.SymmMatrix;
import net.librec.recommender.Recommender;
import net.librec.recommender.RecommenderContext;
import net.librec.recommender.item.RecommendedItem;
import net.librec.similarity.RecommenderSimilarity;
import net.librec.util.DriverClassUtil;
import net.librec.util.FileUtil;
import net.librec.util.JobUtil;
import net.librec.util.ReflectionUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RecommenderJob {
    protected final Log LOG = LogFactory.getLog(RecommenderJob.class);
    private Configuration conf;
    private DataModel dataModel;
    private Map<String, List<Double>> cvEvalResults;
    private Map<Measure.MeasureValue, Double> evaluatedMap;
    private Recommender recommender;

    public RecommenderJob(Configuration conf) {
        this.conf = conf;
        Long seed = conf.getLong("rec.random.seed");
        if (seed != null) {
            Randoms.seed(seed);
        }
        this.setJobId(JobUtil.generateNewJobId());
    }

    public void runJob() throws LibrecException, ClassNotFoundException, IOException {
        this.executeRecommenderJob();
    }

    private void executeRecommenderJob() throws ClassNotFoundException, LibrecException, IOException {
        this.generateDataModel();
        this.recommender = ReflectionUtil.newInstance(this.getRecommenderClass(), this.conf);
        RecommenderContext context = new RecommenderContext(this.conf);
        this.cvEvalResults = new HashMap<String, List<Double>>();
        while (this.dataModel.hasNextFold()) {
            this.dataModel.nextFold();
            context.setDataModel(this.dataModel);
            this.generateSimilarity(context);
            this.recommender.train(context);
            this.executeEvaluator(this.recommender, context);
        }
        this.printCVAverageResult();
        boolean isRanking = this.conf.getBoolean("rec.recommender.isranking");
        List<RecommendedItem> recommendedList = null;
        recommendedList = isRanking ? this.recommender.getRecommendedList(this.recommender.recommendRank()) : this.recommender.getRecommendedList(this.recommender.recommendRating(context.getDataModel().getTestDataSet()));
        recommendedList = this.filterResult(recommendedList);
        this.saveResult(recommendedList);
    }

    private void generateDataModel() throws ClassNotFoundException, IOException, LibrecException {
        if (null == this.dataModel) {
            this.dataModel = ReflectionUtil.newInstance(this.getDataModelClass(), this.conf);
        }
        this.dataModel.buildDataModel();
    }

    private void generateSimilarity(RecommenderContext context) {
        String[] similarityKeys = this.conf.getStrings("rec.recommender.similarities");
        if (similarityKeys != null && similarityKeys.length > 0) {
            for (int i = 0; i < similarityKeys.length; ++i) {
                if (this.getSimilarityClass(i) == null) continue;
                RecommenderSimilarity similarity = ReflectionUtil.newInstance(this.getSimilarityClass(i), this.conf);
                this.conf.set("rec.recommender.similarity.key", similarityKeys[i]);
                similarity.buildSimilarityMatrix(this.dataModel);
                if (similarityKeys[i].equals("item") || similarityKeys[i].equals("user")) {
                    context.setSimilarity(similarity);
                }
                context.addSimilarities(similarityKeys[i], similarity);
            }
        }
    }

    private List<RecommendedItem> filterResult(List<RecommendedItem> recommendedList) throws ClassNotFoundException, IOException {
        if (this.getFilterClass() != null) {
            RecommendedFilter filter = ReflectionUtil.newInstance(this.getFilterClass(), null);
            recommendedList = filter.filter(recommendedList);
        }
        return recommendedList;
    }

    private void executeEvaluator(Recommender recommender, RecommenderContext context) throws ClassNotFoundException, IOException, LibrecException {
        block10: {
            EvalContext evalContext;
            block11: {
                if (!this.conf.getBoolean("rec.eval.enable")) break block10;
                DataSet dataSet = this.dataModel.getTestDataSet();
                String[] similarityKeys = this.conf.getStrings("rec.recommender.similarities");
                evalContext = null;
                if (similarityKeys != null && similarityKeys.length > 0) {
                    SymmMatrix similarityMatrix = context.getSimilarity().getSimilarityMatrix();
                    Map<String, RecommenderSimilarity> similarities = context.getSimilarities();
                    evalContext = new EvalContext(this.conf, recommender, dataSet, similarityMatrix, similarities);
                } else {
                    evalContext = new EvalContext(this.conf, recommender, dataSet);
                }
                String[] evalClassKeys = this.conf.getStrings("rec.eval.classes");
                if (evalClassKeys == null || evalClassKeys.length <= 0) break block11;
                for (int classIdx = 0; classIdx < evalClassKeys.length; ++classIdx) {
                    RecommenderEvaluator evaluator = ReflectionUtil.newInstance(this.getEvaluatorClass(evalClassKeys[classIdx]), null);
                    evaluator.setTopN(this.conf.getInt("rec.recommender.ranking.topn", 10));
                    evaluator.setDataModel(this.dataModel);
                    double evalValue = evaluator.evaluate(evalContext);
                    this.LOG.info("Evaluator info:" + evaluator.getClass().getSimpleName() + " is " + evalValue);
                    this.collectCVResults(evaluator.getClass().getSimpleName(), evalValue);
                }
                break block10;
            }
            this.evaluatedMap = new HashMap<Measure.MeasureValue, Double>();
            boolean isRanking = this.conf.getBoolean("rec.recommender.isranking");
            int topN = 10;
            if (isRanking && (topN = this.conf.getInt("rec.recommender.ranking.topn", 10).intValue()) <= 0) {
                throw new IndexOutOfBoundsException("rec.recommender.ranking.topn should be more than 0!");
            }
            List<Measure.MeasureValue> measureValueList = Measure.getMeasureEnumList(isRanking, topN);
            if (measureValueList != null) {
                for (Measure.MeasureValue measureValue : measureValueList) {
                    RecommenderEvaluator evaluator = ReflectionUtil.newInstance(measureValue.getMeasure().getEvaluatorClass());
                    if (isRanking && measureValue.getTopN() != null && measureValue.getTopN() > 0) {
                        evaluator.setTopN(measureValue.getTopN());
                    }
                    double evaluatedValue = evaluator.evaluate(evalContext);
                    this.evaluatedMap.put(measureValue, evaluatedValue);
                }
            }
            if (this.evaluatedMap.size() <= 0) break block10;
            for (Map.Entry entry : this.evaluatedMap.entrySet()) {
                String evalName = null;
                if (entry == null || entry.getKey() == null) continue;
                if (((Measure.MeasureValue)entry.getKey()).getTopN() != null && ((Measure.MeasureValue)entry.getKey()).getTopN() > 0) {
                    this.LOG.info("Evaluator value:" + (Object)((Object)((Measure.MeasureValue)entry.getKey()).getMeasure()) + " top " + ((Measure.MeasureValue)entry.getKey()).getTopN() + " is " + entry.getValue());
                    evalName = (Object)((Object)((Measure.MeasureValue)entry.getKey()).getMeasure()) + " top " + ((Measure.MeasureValue)entry.getKey()).getTopN();
                } else {
                    this.LOG.info("Evaluator value:" + (Object)((Object)((Measure.MeasureValue)entry.getKey()).getMeasure()) + " is " + entry.getValue());
                    evalName = (Object)((Object)((Measure.MeasureValue)entry.getKey()).getMeasure()) + "";
                }
                if (null == this.cvEvalResults) continue;
                this.collectCVResults(evalName, (Double)entry.getValue());
            }
        }
    }

    public void saveResult(List<RecommendedItem> recommendedList) throws LibrecException, IOException, ClassNotFoundException {
        if (recommendedList != null && recommendedList.size() > 0) {
            String algoSimpleName = DriverClassUtil.getDriverName(this.getRecommenderClass());
            String outputPath = this.conf.get("dfs.result.dir") + "/" + this.conf.get("data.input.path") + "-" + algoSimpleName + "-output/" + algoSimpleName;
            if (null != this.dataModel && (this.dataModel.getDataSplitter() instanceof KCVDataSplitter || this.dataModel.getDataSplitter() instanceof LOOCVDataSplitter) && null != this.conf.getInt("data.splitter.cv.index")) {
                outputPath = outputPath + "-" + String.valueOf(this.conf.getInt("data.splitter.cv.index"));
            }
            this.LOG.info("Result path is " + outputPath);
            StringBuilder sb = new StringBuilder();
            for (RecommendedItem recItem : recommendedList) {
                String userId = recItem.getUserId();
                String itemId = recItem.getItemId();
                String value = String.valueOf(recItem.getValue());
                sb.append(userId).append(",").append(itemId).append(",").append(value).append("\n");
            }
            String resultData = sb.toString();
            try {
                FileUtil.writeString(outputPath, resultData);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void printCVAverageResult() {
        DataSplitter splitter = this.dataModel.getDataSplitter();
        if (splitter != null && (splitter instanceof KCVDataSplitter || splitter instanceof LOOCVDataSplitter)) {
            this.LOG.info("Average Evaluation Result of Cross Validation:");
            for (Map.Entry<String, List<Double>> entry : this.cvEvalResults.entrySet()) {
                String evalName = entry.getKey();
                List<Double> evalList = entry.getValue();
                double sum2 = 0.0;
                for (double value : evalList) {
                    sum2 += value;
                }
                double avgEvalResult = sum2 / (double)evalList.size();
                this.LOG.info("Evaluator value:" + evalName + " is " + avgEvalResult);
            }
        }
    }

    private void collectCVResults(String evalName, Double evalValue) {
        DataSplitter splitter = this.dataModel.getDataSplitter();
        if (splitter != null && (splitter instanceof KCVDataSplitter || splitter instanceof LOOCVDataSplitter)) {
            if (this.cvEvalResults.containsKey(evalName)) {
                this.cvEvalResults.get(evalName).add(evalValue);
            } else {
                ArrayList<Double> newList = new ArrayList<Double>();
                newList.add(evalValue);
                this.cvEvalResults.put(evalName, newList);
            }
        }
    }

    private void setJobId(String jobId) {
        this.conf.set("rec.job.id", jobId);
    }

    public void setRecommenderClass(String jobClass) {
        this.conf.set("rec.recommender.class", jobClass);
    }

    public void setRecommenderClass(Class<Recommender> jobClass) {
        this.conf.set("rec.recommender.class", jobClass.getName());
    }

    public Class<? extends DataModel> getDataModelClass() throws ClassNotFoundException, IOException {
        return DriverClassUtil.getClass(this.conf.get("data.model.format"));
    }

    public Class<? extends RecommenderSimilarity> getSimilarityClass(int i) {
        String[] similarityClassKeys = this.conf.getStrings("rec.similarity.class");
        try {
            if (similarityClassKeys.length >= 2) {
                return DriverClassUtil.getClass(similarityClassKeys[i]);
            }
            return DriverClassUtil.getClass(similarityClassKeys[0]);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public Class<? extends Recommender> getRecommenderClass() throws ClassNotFoundException, IOException {
        return DriverClassUtil.getClass(this.conf.get("rec.recommender.class"));
    }

    public Class<? extends RecommenderEvaluator> getEvaluatorClass(String evalClassKey) throws ClassNotFoundException, IOException {
        return DriverClassUtil.getClass(evalClassKey);
    }

    public Class<? extends RecommendedFilter> getFilterClass() throws ClassNotFoundException, IOException {
        return DriverClassUtil.getClass(this.conf.get("rec.filter.class"));
    }

    public Map<Measure.MeasureValue, Double> getEvaluatedMap() {
        return this.evaluatedMap;
    }
}

