/*
 * Decompiled with CFR 0.152.
 */
package net.librec.job.progress;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.junit.Test;

public class ProgressBar {
    private double finishPoint;
    private double barLength;
    private SimpleDateFormat formatter = new SimpleDateFormat(" MM-dd HH:mm:ss");

    public ProgressBar() {
        this.finishPoint = 100.0;
        this.barLength = 20.0;
    }

    public ProgressBar(double finishPoint, int barLength) {
        this.finishPoint = finishPoint;
        this.barLength = barLength;
    }

    @Test
    public void showBarByPoint(double currentPoint) {
        double rate = currentPoint / this.finishPoint;
        int barSign = (int)(rate * this.barLength);
        System.out.println(this.makeBarBySignAndLength(barSign) + String.format(" %.2f%%", rate * 100.0) + " " + this.formatter.format(new Date()));
    }

    private String makeBarBySignAndLength(int barSign) {
        StringBuilder bar = new StringBuilder();
        bar.append("[");
        int i = 1;
        while ((double)i <= this.barLength) {
            if (i < barSign) {
                bar.append("-");
            } else if (i == barSign) {
                bar.append(">");
            } else {
                bar.append(" ");
            }
            ++i;
        }
        bar.append("]");
        return bar.toString();
    }

    public static void main(String[] args) {
        ProgressBar pb = new ProgressBar(100.0, 100);
        for (int i = 0; i <= 100; i += 20) {
            pb.showBarByPoint(i);
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

