/*
 * Decompiled with CFR 0.152.
 */
package net.librec.math.algorithm;

public class Gaussian {
    public static double pdf(double x) {
        return Math.exp(-x * x / 2.0) / Math.sqrt(Math.PI * 2);
    }

    public static double pdf(double x, double mu, double sigma) {
        return Gaussian.pdf((x - mu) / sigma) / sigma;
    }

    public static double cdf(double z) {
        if (z < -8.0) {
            return 0.0;
        }
        if (z > 8.0) {
            return 1.0;
        }
        double sum2 = 0.0;
        double term = z;
        int i = 3;
        while (sum2 + term != sum2) {
            sum2 += term;
            term = term * z * z / (double)i;
            i += 2;
        }
        return 0.5 + sum2 * Gaussian.pdf(z);
    }

    public static double cdf(double z, double mu, double sigma) {
        return Gaussian.cdf((z - mu) / sigma);
    }

    public static double PhiInverse(double y) {
        return Gaussian.PhiInverse(y, 1.0E-8, -8.0, 8.0);
    }

    private static double PhiInverse(double y, double delta, double lo, double hi) {
        double mid = lo + (hi - lo) / 2.0;
        if (hi - lo < delta) {
            return mid;
        }
        if (Gaussian.cdf(mid) > y) {
            return Gaussian.PhiInverse(y, delta, lo, mid);
        }
        return Gaussian.PhiInverse(y, delta, mid, hi);
    }

    public static double PhiInverse(double y, double mu, double sigma) {
        return Gaussian.PhiInverse2(y, mu, sigma, 1.0E-8, mu - 8.0 * sigma, mu + 8.0 * sigma);
    }

    private static double PhiInverse2(double y, double mu, double sigma, double delta, double lo, double hi) {
        double mid = lo + (hi - lo) / 2.0;
        if (hi - lo < delta) {
            return mid;
        }
        if (Gaussian.cdf(mid, mu, sigma) > y) {
            return Gaussian.PhiInverse2(y, mu, sigma, delta, lo, mid);
        }
        return Gaussian.PhiInverse2(y, mu, sigma, delta, mid, hi);
    }

    public static void main(String[] args) {
        double z;
        double mu = 2.0;
        double sigma = 1.5;
        System.out.println("PDF for N(2.0,0.6) in range [-4..8]:");
        for (z = -4.0; z <= 8.0; z += 0.2) {
            System.out.format("%.1f\t%.4f\n", z, Gaussian.pdf(z, mu, sigma));
        }
        System.out.println("CDF for N(2.0,0.6) in range [-4..8]:");
        for (z = -4.0; z <= 8.0; z += 0.2) {
            System.out.format("%.1f\t%.4f\n", z, Gaussian.cdf(z, mu, sigma));
        }
        System.out.format("\nIf X ~ N(2.0, 1.5), then P(X <= 3.2) is %.4f\n", Gaussian.cdf(3.2, 2.0, 1.5));
        System.out.format("\nIf X ~ N(2.0, 1.5), then x such that P(X <= x ) = 0.7881 is %.4f\n", Gaussian.PhiInverse(0.7881, 2.0, 1.5));
    }
}

