/*
 * Decompiled with CFR 0.152.
 */
package net.librec.math.algorithm;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class Stats {
    public static double mean(Collection<? extends Number> data) {
        double sum2 = 0.0;
        int count = 0;
        for (Number number : data) {
            if (Double.isNaN(number.doubleValue())) continue;
            sum2 += number.doubleValue();
            ++count;
        }
        return sum2 / (double)count;
    }

    public static double hMean(double a, double b) {
        return 2.0 * a * b / (a + b);
    }

    public static double mean(double[] data) {
        return Stats.mean(data, 0, data.length);
    }

    public static double mean(double[] data, int from, int to) {
        double sum2 = 0.0;
        int count = 0;
        for (int index = from; index < to; ++index) {
            double value = data[index];
            sum2 += value;
            ++count;
        }
        return sum2 / (double)count;
    }

    public static double sum(double[] data, int from, int to) {
        double sum2 = 0.0;
        for (int index = from; index < to; ++index) {
            sum2 += data[index];
        }
        return sum2;
    }

    public static double variance(double[] data, int from, int to, double mean) {
        if (data.length == 0) {
            return Double.NaN;
        }
        double sum2 = 0.0;
        for (int index = from; index < to; ++index) {
            sum2 += (data[index] - mean) * (data[index] - mean);
        }
        return sum2 / (double)(to - from);
    }

    public static double standardDeviation(double[] data, int from, int to, double mean) {
        return Math.sqrt(Stats.variance(data, from, to, mean));
    }

    public static double mode(double[] data) {
        HashMap<Double, Integer> modes = new HashMap<Double, Integer>();
        double mode = Double.NaN;
        int max = 0;
        for (double d : data) {
            int count = 0;
            if (modes.containsKey(d)) {
                count = (Integer)modes.get(d);
            }
            if (max < ++count) {
                mode = d;
                max = count;
            }
            modes.put(d, count);
        }
        return mode;
    }

    public static double weightedcMean(double[] a, double[] w) {
        double sum2 = 0.0;
        double ws = 0.0;
        for (int i = 0; i < a.length; ++i) {
            if (Double.isNaN(a[i]) || Double.isNaN(w[i])) continue;
            sum2 += a[i] * w[i];
            ws += w[i];
        }
        return sum2 / ws;
    }

    public static double average(List<Double> data, List<Double> weights) {
        double sum2 = 0.0;
        double ws = 0.0;
        for (int i = 0; i < data.size(); ++i) {
            double value = data.get(i);
            double weight = weights.get(i);
            sum2 += value * weight;
            ws += weight;
        }
        return sum2 / ws;
    }

    public static double median(double[] data) {
        double median = 0.0;
        double[] clones = (double[])data.clone();
        Arrays.sort(clones);
        int size = clones.length;
        int index = 0;
        if (size % 2 == 0) {
            index = clones.length / 2 - 1;
            median = (clones[index] + clones[index + 1]) / 2.0;
        } else {
            index = (clones.length + 1) / 2 - 1;
            median = clones[index];
        }
        return median;
    }

    public static double median(Collection<? extends Number> data) {
        return Stats.median(Stats.toArray(data));
    }

    public static double[] toArray(Collection<? extends Number> data) {
        if (data == null || data.size() < 1) {
            return null;
        }
        double[] da = new double[data.size()];
        int i = 0;
        for (Number number : data) {
            da[i++] = number.doubleValue();
        }
        return da;
    }

    public static double variance(double[] data) {
        return Stats.variance(data, Stats.mean(data));
    }

    public static double variance(double[] data, double mean) {
        return Stats.variance(data, 0, data.length, mean);
    }

    public static double standardDeviation(Collection<? extends Number> data) {
        return Stats.standardDeviation(data, Stats.mean(data));
    }

    public static double standardDeviation(Collection<? extends Number> data, double mean) {
        double sum2 = 0.0;
        for (Number number : data) {
            sum2 += Math.pow(number.doubleValue() - mean, 2.0);
        }
        return Math.sqrt(sum2 / (double)data.size());
    }

    public static double standardDeviation(double[] data) {
        return Stats.standardDeviation(data, Stats.mean(data));
    }

    public static double standardDeviation(double[] data, double mean) {
        return Math.sqrt(Stats.variance(data, mean));
    }

    public static double sum(double[] data) {
        return Stats.sum(data, 0, data.length);
    }

    public static double sum(Collection<? extends Number> data) {
        double sum2 = 0.0;
        for (Number number : data) {
            sum2 += number.doubleValue();
        }
        return sum2;
    }

    public static int sum(int[] data) {
        int sum2 = 0;
        for (int i = 0; i < data.length; ++i) {
            sum2 += data[i];
        }
        return sum2;
    }

    public static int sum(int n) {
        return n * (n - 1) / 2;
    }

    public static double sumSquare(int n) {
        return (double)n * ((double)n + 0.5) * (double)(n + 1) / 3.0;
    }

    public static double[] max(double[] data) {
        double max = Double.NEGATIVE_INFINITY;
        int index = -1;
        for (int i = 0; i < data.length; ++i) {
            if (!(max < data[i])) continue;
            max = data[i];
            index = i;
        }
        return new double[]{max, index};
    }

    public static int[] max(int[] data) {
        int max = Integer.MIN_VALUE;
        int index = -1;
        for (int i = 0; i < data.length; ++i) {
            if (max >= data[i]) continue;
            max = data[i];
            index = i;
        }
        return new int[]{max, index};
    }

    public static int[] min(int[] data) {
        int min = Integer.MAX_VALUE;
        int index = -1;
        for (int i = 0; i < data.length; ++i) {
            if (min <= data[i]) continue;
            min = data[i];
            index = i;
        }
        return new int[]{min, index};
    }

    public static double[] min(double[] data) {
        double min = Double.POSITIVE_INFINITY;
        int index = -1;
        for (int i = 0; i < data.length; ++i) {
            if (!(min > data[i])) continue;
            min = data[i];
            index = i;
        }
        return new double[]{min, index};
    }
}

