/*
 * Decompiled with CFR 0.152.
 */
package net.librec.math.structure;

import net.librec.math.structure.DataSet;
import net.librec.math.structure.Matrix;
import net.librec.math.structure.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractMatrix
implements Matrix,
DataSet {
    protected final Log LOG = LogFactory.getLog(this.getClass());
    protected int rows;
    protected int columns;

    public AbstractMatrix(int rows, int columns) {
        this.rows = rows;
        this.columns = columns;
    }

    @Override
    public int columnSize() {
        return this.columns;
    }

    @Override
    public int size() {
        return this.getNumEntries();
    }

    @Override
    public int rowSize() {
        return this.rows;
    }

    @Override
    public AbstractMatrix clone() {
        try {
            return (AbstractMatrix)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String toString() {
        int maxRowsToDisplay = 10;
        StringBuilder s = new StringBuilder("{\n");
        for (int rowIndex = 0; rowIndex < maxRowsToDisplay && rowIndex < this.rowSize(); ++rowIndex) {
            Vector vector = this.row(rowIndex);
            s.append(" ").append(rowIndex).append(" =>\t").append(vector.toString()).append('\n');
        }
        String returnString = s.toString();
        if (maxRowsToDisplay <= this.rowSize()) {
            return returnString + "... }";
        }
        return returnString + "}";
    }
}

