/*
 * Decompiled with CFR 0.152.
 */
package net.librec.math.structure;

import com.google.common.primitives.Doubles;
import java.util.Iterator;
import net.librec.math.structure.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractVector
implements Vector {
    private static final Log LOG = LogFactory.getLog(AbstractVector.class);
    protected int cardinality;

    public AbstractVector(int cardinality) {
        this.cardinality = cardinality;
    }

    @Override
    public Vector.VectorEntry getVectorEntry(int index) {
        return new LocalVectorEntry(index);
    }

    @Override
    public double norm(double power) {
        if (power < 0.0) {
            throw new IllegalArgumentException("Power must be >= 0");
        }
        if (Double.isInfinite(power)) {
            double result = 0.0;
            for (Vector.VectorEntry vectorEntry : this) {
                result = Math.max(result, Math.abs(vectorEntry.get()));
            }
            return result;
        }
        if (power == 2.0) {
            return Math.sqrt(this.getLengthSquared());
        }
        if (power == 1.0) {
            double result = 0.0;
            for (Vector.VectorEntry vectorEntry : this) {
                result += Math.abs(vectorEntry.get());
            }
            return result;
        }
        if (power == 0.0) {
            return this.getNumEntries();
        }
        double result = 0.0;
        for (Vector.VectorEntry vectorEntry : this) {
            result += Math.pow(vectorEntry.get(), power);
        }
        result = Math.pow(result, 1.0 / power);
        return result;
    }

    @Override
    public double sum() {
        double result = 0.0;
        for (Vector.VectorEntry vectorEntry : this) {
            result += vectorEntry.get();
        }
        return result;
    }

    @Override
    public double mean() {
        return this.sum() / (double)this.getNumEntries();
    }

    protected double dotSelf() {
        double result = 0.0;
        for (Vector.VectorEntry vectorEntry : this) {
            result += Math.pow(vectorEntry.get(), 2.0);
        }
        return result;
    }

    @Override
    public double getLengthSquared() {
        return this.dotSelf();
    }

    @Override
    public final int size() {
        return this.getNumEntries();
    }

    @Override
    public final int cardinality() {
        return this.cardinality;
    }

    public int hashCode() {
        int result = this.cardinality;
        for (Vector.VectorEntry entry : this) {
            result += entry.index() * Doubles.hashCode(entry.get());
        }
        return result;
    }

    public boolean equals(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return this.toString(null);
    }

    public String toString(String[] dictionary) {
        StringBuilder result = new StringBuilder();
        result.append('{');
        for (int index = 0; index < this.cardinality; ++index) {
            double value = this.get(index);
            if (value == 0.0) continue;
            result.append(dictionary != null && dictionary.length > index ? dictionary[index] : Integer.valueOf(index));
            result.append(':');
            result.append(value);
            result.append(',');
        }
        if (result.length() > 1) {
            result.setCharAt(result.length() - 1, '}');
        } else {
            result.append('}');
        }
        return result.toString();
    }

    public String sparseVectorToString() {
        Iterator iter = this.iterator();
        if (!iter.hasNext()) {
            return "{}";
        }
        StringBuilder result = new StringBuilder();
        result.append('{');
        while (iter.hasNext()) {
            Vector.VectorEntry vectorEntry = (Vector.VectorEntry)iter.next();
            result.append(vectorEntry.index());
            result.append(':');
            result.append(vectorEntry.get());
            result.append(',');
        }
        result.setCharAt(result.length() - 1, '}');
        return result.toString();
    }

    protected final class LocalVectorEntry
    implements Vector.VectorEntry {
        int index;

        LocalVectorEntry(int index) {
            this.index = index;
        }

        @Override
        public double get() {
            return AbstractVector.this.get(this.index);
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public int position() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(double value) {
            AbstractVector.this.set(this.index, value);
        }
    }
}

