/*
 * Decompiled with CFR 0.152.
 */
package net.librec.math.structure;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashBiMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.librec.conf.Configuration;
import net.librec.math.structure.DataSet;
import net.librec.math.structure.SequentialAccessSparseMatrix;
import net.librec.math.structure.SparseTensor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataFrame
implements Serializable,
DataSet {
    private static final Log LOG = LogFactory.getLog(DataFrame.class);
    private static Map<String, BiMap<String, Integer>> featuresInnerMapping;
    private String name;
    private List<String> header;
    private List<String> attrType;
    private List<List<Object>> data;
    private List<Double> ratingScale;

    public DataFrame() {
        this.data = new ArrayList<List<Object>>();
    }

    public DataFrame(DataFrame df) {
        this.data = df.getData();
        this.name = df.getName();
        this.header = df.getHeader();
        this.attrType = df.getAttrType();
    }

    @Override
    public int size() {
        if (this.data == null) {
            return 0;
        }
        return this.data.get(0).size();
    }

    public void add(String[] input) {
        int i;
        if (this.data == null) {
            this.data = new ArrayList<List<Object>>(input.length);
        }
        if (this.data.size() == 0) {
            for (i = 0; i < input.length; ++i) {
                this.data.add(new ArrayList());
            }
        }
        for (i = 0; i < input.length; ++i) {
            this.getData().get(i).add(this.addData(i, input[i]));
        }
    }

    private Object addData(int columnIndex, String input) {
        if (Objects.equals(this.attrType.get(columnIndex), "STRING")) {
            return this.getId(input, this.header.get(columnIndex));
        }
        if (Objects.equals(this.attrType.get(columnIndex), "NOMINAL")) {
            return this.getId(input, this.header.get(columnIndex));
        }
        if (Objects.equals(this.attrType.get(columnIndex), "NUMERIC")) {
            return Double.valueOf(input);
        }
        if (Objects.equals(this.attrType.get(columnIndex), "DATE")) {
            return Long.parseLong(input);
        }
        return null;
    }

    public void setHeader(String[] header) {
        this.header = Arrays.asList(header);
    }

    public SequentialAccessSparseMatrix toSparseMatrix(Configuration conf) {
        if (Objects.equals(conf.get("data.convert.columns"), null)) {
            if (Objects.equals(conf.get("data.convert.binarize.threshold"), null)) {
                return this.toSparseMatrix();
            }
            return this.toSparseMatrix(conf.getDouble("data.convert.binarize.threshold"));
        }
        if (Objects.equals(conf.get("data.convert.binarize.threshold"), null)) {
            return this.toSparseMatrix(conf.get("data.convert.columns").split(","));
        }
        return this.toSparseMatrix(conf.get("data.convert.columns").split(","), conf.getDouble("data.convert.binarize.threshold"));
    }

    public SequentialAccessSparseMatrix toSparseMatrix() {
        return this.toSparseMatrix(new String[]{"user", "item", "rating"}, -1.0);
    }

    public SequentialAccessSparseMatrix toSparseMatrix(double binThold) {
        return this.toSparseMatrix(new String[]{"user", "item", "rating"}, binThold);
    }

    public SequentialAccessSparseMatrix toSparseMatrix(String[] headerIndices) {
        return this.toSparseMatrix(headerIndices, -1.0);
    }

    public SequentialAccessSparseMatrix toSparseMatrix(String[] headerIndics, double binThold) {
        if (headerIndics.length != 3) {
            return null;
        }
        int indexColumn1 = this.header.indexOf(headerIndics[0]);
        int indexColumn2 = this.header.indexOf(headerIndics[1]);
        int valueColumn = this.header.indexOf(headerIndics[2]);
        return this.toSparseMatrix(indexColumn1, indexColumn2, valueColumn, binThold);
    }

    public SequentialAccessSparseMatrix toSparseMatrix(String str) {
        if (Objects.equals(str, "datetimeMatrix")) {
            return this.toSparseMatrix(new String[]{"user", "item", "datetime"});
        }
        if (Objects.equals(str, "preferenceMatrix")) {
            return this.toSparseMatrix(new String[]{"user", "item", "rating"});
        }
        return null;
    }

    public SequentialAccessSparseMatrix toSparseMatrix(int indexColumn1, int indexColumn2, int valueColumn) {
        return this.toSparseMatrix(indexColumn1, indexColumn2, valueColumn, -1.0);
    }

    public SequentialAccessSparseMatrix toSparseMatrix(int indexColumn1, int indexColumn2, int valueColumn, double binThold) {
        if (this.data.size() == 0 || this.data.size() <= valueColumn) {
            return null;
        }
        if (Objects.equals(this.attrType.get(valueColumn), "NUMERIC")) {
            HashBasedTable<Integer, Integer, Double> dataTable = HashBasedTable.create();
            for (int i = this.getData().get(0).size() - 1; i >= 0; --i) {
                int row = (Integer)this.getData().get(indexColumn1).get(i);
                int col = (Integer)this.getData().get(indexColumn2).get(i);
                Double rate = valueColumn == -1 ? 1.0 : (Double)this.getData().get(valueColumn).get(i);
                if (binThold >= 0.0) {
                    rate = rate > binThold ? 1.0 : -1.0;
                }
                dataTable.put(row, col, rate);
            }
            this.flushCache(Arrays.asList(indexColumn1, indexColumn2));
            SequentialAccessSparseMatrix matrix = new SequentialAccessSparseMatrix(featuresInnerMapping.get(this.header.get(indexColumn1)).size(), featuresInnerMapping.get(this.header.get(indexColumn2)).size(), dataTable);
            return matrix;
        }
        if (Objects.equals(this.attrType.get(valueColumn), "DATE")) {
            HashBasedTable<Integer, Integer, Long> dataTable = HashBasedTable.create();
            for (int i = this.getData().get(0).size() - 1; i >= 0; --i) {
                int row = (Integer)this.getData().get(indexColumn1).get(i);
                int col = (Integer)this.getData().get(indexColumn2).get(i);
                Long mms = 0L;
                mms = (Long)this.getData().get(valueColumn).get(i);
                dataTable.put(row, col, mms);
            }
            this.flushCache(Arrays.asList(indexColumn1, indexColumn2));
            SequentialAccessSparseMatrix matrix = new SequentialAccessSparseMatrix(featuresInnerMapping.get(this.header.get(indexColumn1)).size(), featuresInnerMapping.get(this.header.get(indexColumn2)).size(), dataTable);
            return matrix;
        }
        LOG.info("fail to create sparseMatrix, please check attributes type");
        return null;
    }

    public SparseTensor toSparseTensor() {
        ArrayList<Integer> _indexColumn = new ArrayList<Integer>();
        int valueColumn = -1;
        for (int i = 0; i < this.header.size(); ++i) {
            if (featuresInnerMapping.containsKey(this.header.get(i)) && featuresInnerMapping.get(this.header.get(i)).size() != 0) {
                _indexColumn.add(i);
            }
            if (!this.header.get(i).toLowerCase().equals("rating")) continue;
            valueColumn = i;
        }
        int[] indexColumn = new int[_indexColumn.size()];
        for (int i = 0; i < _indexColumn.size(); ++i) {
            indexColumn[i] = (Integer)_indexColumn.get(i);
        }
        return this.toSparseTensor(indexColumn, valueColumn);
    }

    public SparseTensor toSparseTensor(String[] indicesColumn, String valueColumn) {
        int[] index = new int[indicesColumn.length];
        for (int i = 0; i < indicesColumn.length; ++i) {
            index[i] = this.header.indexOf(indicesColumn[i]);
        }
        return this.toSparseTensor(index, this.header.indexOf(valueColumn));
    }

    public SparseTensor toSparseTensor(int[] indicesColumn, int valueColumn) {
        int d;
        ArrayList<Double> rating = new ArrayList<Double>();
        List[] nDKeys = new List[indicesColumn.length];
        int[] dims = new int[indicesColumn.length];
        int userDimension = -1;
        int itemDimension = -1;
        for (d = 0; d < indicesColumn.length; ++d) {
            nDKeys[d] = new ArrayList(this.getData().get(indicesColumn[d]).size());
            dims[d] = DataFrame.getInnerMapping(this.header.get(indicesColumn[d])).size();
            if (Objects.equals(this.header.get(indicesColumn[d]), "user")) {
                userDimension = d;
            }
            if (!Objects.equals(this.header.get(indicesColumn[d]), "item")) continue;
            itemDimension = d;
        }
        for (d = 0; d < indicesColumn.length; ++d) {
            for (Object s : this.getData().get(indicesColumn[d])) {
                nDKeys[d].add((Integer)s);
            }
        }
        for (Object s : this.getData().get(valueColumn)) {
            rating.add((Double)s);
        }
        SparseTensor tensor = new SparseTensor(dims, nDKeys, rating);
        if (userDimension != -1) {
            tensor.setUserDimension(userDimension);
        }
        if (itemDimension != -1) {
            tensor.setItemDimension(itemDimension);
        }
        return tensor;
    }

    public static int setId(String input, String attrName) {
        BiMap<String, Integer> innerMap = DataFrame.getInnerMapping(attrName);
        if (innerMap.containsKey(input)) {
            return (Integer)innerMap.get(input);
        }
        int cur = innerMap.size();
        innerMap.put(input, cur);
        return cur;
    }

    private int getId(String input, String attrName) {
        if (featuresInnerMapping.keySet().contains(attrName)) {
            return (Integer)featuresInnerMapping.get(attrName).get(input);
        }
        return -1;
    }

    public static BiMap<String, Integer> getInnerMapping(String attrName) {
        if (featuresInnerMapping == null) {
            featuresInnerMapping = new HashMap<String, BiMap<String, Integer>>();
        }
        if (!featuresInnerMapping.keySet().contains(attrName)) {
            featuresInnerMapping.put(attrName, HashBiMap.create());
        }
        return featuresInnerMapping.get(attrName);
    }

    public static void clearInnerMapping() {
        featuresInnerMapping = new HashMap<String, BiMap<String, Integer>>();
    }

    public void addHeader(String attrName) {
        if (this.header == null) {
            this.header = new ArrayList<String>();
        }
        this.header.add(attrName);
    }

    public List<String> getHeader() {
        return this.header;
    }

    public String getHeader(int i) {
        if (i < this.header.size() && 0 <= i) {
            return this.header.get(i);
        }
        return null;
    }

    public Object get(int index1, int index2) {
        return this.getData().get(index2).get(index1);
    }

    private int getUserId(String user) {
        return (Integer)DataFrame.getInnerMapping("user").get(user);
    }

    private int getItemId(String item) {
        return (Integer)DataFrame.getInnerMapping("item").get(item);
    }

    private void flushCache(List<Integer> index) {
        boolean clean = true;
        for (int i = 0; i < this.getData().size(); ++i) {
            if (index.contains(i) || this.getData().get(i).size() == 0) continue;
            clean = false;
        }
        if (clean) {
            this.data = null;
        }
    }

    public static BiMap<String, Integer> getUserIds() {
        return DataFrame.getInnerMapping("user");
    }

    public static BiMap<String, Integer> getItemIds() {
        return DataFrame.getInnerMapping("item");
    }

    public static DataFrame merge(DataFrame a, DataFrame b) {
        return new DataFrame();
    }

    public static DataFrame loadArff(String ... path) {
        return new DataFrame();
    }

    public void setAttrType(String[] attrType) {
        this.attrType = Arrays.asList(attrType);
    }

    public void setHeader(List<String> header) {
        this.header = header;
    }

    public List<List<Object>> getData() {
        return this.data;
    }

    private void setData(List<List<Object>> data) {
        this.data = data;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String input) {
        this.name = input;
    }

    public List<String> getAttrType() {
        return this.attrType;
    }

    public void setAttrType(List<String> attrType) {
        this.attrType = new ArrayList<String>(attrType);
    }

    public int numUsers() {
        return DataFrame.getUserIds().size();
    }

    public int numItems() {
        return DataFrame.getItemIds().size();
    }

    public List<Double> getRatingScale() {
        int index = this.header.indexOf("rating");
        if (index == -1) {
            return null;
        }
        HashSet scale = new HashSet(this.getData().get(index));
        ArrayList<Double> ratingScale = new ArrayList<Double>(scale.size());
        for (Object o : scale) {
            ratingScale.add((Double)o);
        }
        ratingScale.sort((o1, o2) -> {
            if (o1 > o2) {
                return 1;
            }
            return -1;
        });
        return new ArrayList<Double>(ratingScale);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String h : this.header) {
            sb.append(' ' + h);
        }
        sb.append("\n");
        for (int i = 0; i < this.getData().get(0).size(); ++i) {
            for (int j = 0; j < this.header.size(); ++j) {
                sb.append(32.0 + Double.parseDouble(this.getData().get(j).get(i).toString()));
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    class MultiIndex {
        Set<String> labels;
        List<String> levels;

        MultiIndex() {
        }
    }
}

