/*
 * Decompiled with CFR 0.152.
 */
package net.librec.math.structure;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.librec.common.CardinalityException;
import net.librec.math.algorithm.Randoms;
import net.librec.math.structure.AbstractMatrix;
import net.librec.math.structure.DenseVector;
import net.librec.math.structure.Matrix;
import net.librec.math.structure.MatrixAssigner;
import net.librec.math.structure.MatrixBasedDenseVector;
import net.librec.math.structure.MatrixEntry;
import net.librec.math.structure.Vector;
import net.librec.math.structure.VectorBasedDenseVector;

public class DenseMatrix
extends AbstractMatrix
implements Serializable {
    private static final long serialVersionUID = -2069621030647530185L;
    private double[][] values;

    public DenseMatrix(double[][] values) {
        this(values, false);
    }

    public DenseMatrix(double[][] values, boolean shallowCopy) {
        super(values.length, values[0].length);
        if (shallowCopy) {
            this.values = values;
        } else {
            this.values = new double[values.length][];
            for (int i = 0; i < values.length; ++i) {
                this.values[i] = new double[values[i].length];
                System.arraycopy(values[i], 0, this.values[i], 0, this.values[i].length);
            }
        }
    }

    public DenseMatrix(int rows, int columns) {
        super(rows, columns);
        this.values = new double[rows][columns];
    }

    public DenseMatrix(DenseMatrix denseMatrix) {
        this(denseMatrix.values);
    }

    public DenseMatrix assign(DenseMatrix matrix) {
        if (matrix.values[0].length != this.values[0].length || matrix.values.length != this.values.length) {
            this.values = new double[matrix.values.length][matrix.values[0].length];
        }
        for (int i = 0; i < this.values.length; ++i) {
            System.arraycopy(matrix.values[i], 0, this.values[i], 0, this.values[0].length);
        }
        return this;
    }

    public DenseMatrix assign(MatrixAssigner mapper) {
        for (int row = 0; row < this.rowSize(); ++row) {
            for (int column = 0; column < this.columnSize(); ++column) {
                this.values[row][column] = mapper.getValue(row, column, this.values[row][column]);
            }
        }
        return this;
    }

    public void init(double mean, double sigma) {
        this.assign((int row, int column, double value) -> Randoms.gaussian(mean, sigma));
    }

    public void init(double range) {
        this.assign((int row, int column, double value) -> Randoms.uniform(0.0, range));
    }

    public void init() {
        this.init(1.0);
    }

    @Override
    public DenseMatrix clone() {
        return new DenseMatrix(this.values);
    }

    @Override
    public double get(int row, int column) {
        return this.values[row][column];
    }

    @Override
    public void set(int row, int column, double value) {
        this.values[row][column] = value;
    }

    @Override
    public int getNumEntries() {
        return this.rowSize() * this.columnSize();
    }

    @Override
    public DenseVector row(int row) {
        return new VectorBasedDenseVector(this.values[row], true);
    }

    @Override
    public DenseVector column(int column) {
        return new MatrixBasedDenseVector(this, column);
    }

    @Override
    public DenseVector viewRow(int row) {
        return new VectorBasedDenseVector(this.values[row]);
    }

    @Override
    public DenseVector viewColumn(int column) {
        double[] vectorValues = new double[this.rowSize()];
        for (int rowIndex = 0; rowIndex < this.rowSize(); ++rowIndex) {
            vectorValues[rowIndex] = this.values[rowIndex][column];
        }
        return new VectorBasedDenseVector(vectorValues);
    }

    public void plus(int row, int column, double value) {
        double[] dArray = this.values[row];
        int n = column;
        dArray[n] = dArray[n] + value;
    }

    public DenseMatrix plus(double value) {
        DenseMatrix denseMatrix = this.clone();
        denseMatrix.assign((int row, int column, double matrixValue) -> matrixValue + value);
        return denseMatrix;
    }

    public DenseMatrix plus(Matrix otherMatrix) {
        DenseMatrix denseMatrix = this.clone();
        for (MatrixEntry matrixEntry : otherMatrix) {
            denseMatrix.plus(matrixEntry.row(), matrixEntry.column(), matrixEntry.get());
        }
        return denseMatrix;
    }

    public void set(int row, DenseVector denseVector) {
        for (int columnIndex = 0; columnIndex < denseVector.cardinality(); ++columnIndex) {
            this.set(row, columnIndex, denseVector.get(columnIndex));
        }
    }

    public DenseMatrix minus(Matrix otherMatrix) {
        DenseMatrix denseMatrix = this.clone();
        for (MatrixEntry matrixEntry : otherMatrix) {
            denseMatrix.plus(matrixEntry.row(), matrixEntry.column(), -matrixEntry.get());
        }
        return denseMatrix;
    }

    public DenseMatrix times(double value) {
        DenseMatrix denseMatrix = this.clone();
        denseMatrix.assign((int row, int column, double matrixValue) -> matrixValue * value);
        return denseMatrix;
    }

    public DenseMatrix times(Matrix otherMatrix) {
        if (this.columnSize() != otherMatrix.rowSize()) {
            throw new CardinalityException(this.columnSize(), otherMatrix.rowSize());
        }
        int tempRows = this.rowSize();
        int tempColumns = otherMatrix.columnSize();
        DenseMatrix denseMatrix = new DenseMatrix(tempRows, tempColumns);
        ArrayList<Integer> columnList = new ArrayList<Integer>(denseMatrix.columnSize());
        for (int columnIndex2 = 0; columnIndex2 < denseMatrix.columnSize(); ++columnIndex2) {
            columnList.add(columnIndex2);
        }
        columnList.parallelStream().forEach(columnIndex -> {
            Vector colVector = otherMatrix.viewColumn((int)columnIndex);
            for (int rowIndex = 0; rowIndex < denseMatrix.rowSize(); ++rowIndex) {
                denseMatrix.set(rowIndex, (int)columnIndex, this.row(rowIndex).dot(colVector));
            }
        });
        return denseMatrix;
    }

    public DenseVector times(Vector vector) {
        if (this.columnSize() != vector.cardinality()) {
            throw new CardinalityException(this.columnSize(), vector.cardinality());
        }
        VectorBasedDenseVector resultVector = new VectorBasedDenseVector(this.rowSize());
        for (int rowIndex = 0; rowIndex < this.rowSize(); ++rowIndex) {
            resultVector.set(rowIndex, this.row(rowIndex).dot(vector));
        }
        return resultVector;
    }

    public DenseMatrix transpose() {
        DenseMatrix transposeMatrix = new DenseMatrix(this.columnSize(), this.rowSize());
        for (int transposeRowIndex = 0; transposeRowIndex < transposeMatrix.rowSize(); ++transposeRowIndex) {
            for (int transposeColumnIndex = 0; transposeColumnIndex < transposeMatrix.columnSize(); ++transposeColumnIndex) {
                transposeMatrix.set(transposeRowIndex, transposeColumnIndex, this.values[transposeColumnIndex][transposeRowIndex]);
            }
        }
        return transposeMatrix;
    }

    public double norm() {
        double result = 0.0;
        for (int rowIndex = 0; rowIndex < this.rowSize(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < this.columnSize(); ++columnIndex) {
                result += this.values[rowIndex][columnIndex] * this.values[rowIndex][columnIndex];
            }
        }
        return Math.sqrt(result);
    }

    public DenseMatrix covariance() {
        DenseMatrix resultMatrix = new DenseMatrix(this.columnSize(), this.columnSize());
        for (int resultRowIndex = 0; resultRowIndex < this.columnSize(); ++resultRowIndex) {
            DenseVector columnVector = this.column(resultRowIndex);
            DenseVector columnDenseVector = columnVector.plus(-columnVector.mean());
            resultMatrix.set(resultRowIndex, resultRowIndex, columnDenseVector.dot(columnDenseVector) / (double)(columnDenseVector.cardinality() - 1));
            for (int resultColumnIndex = resultRowIndex + 1; resultColumnIndex < this.columnSize(); ++resultColumnIndex) {
                DenseVector columnVector_2 = this.column(resultColumnIndex);
                double value = columnDenseVector.dot(columnVector_2.plus(-columnVector_2.mean())) / (double)(columnDenseVector.cardinality() - 1);
                resultMatrix.set(resultRowIndex, resultColumnIndex, value);
                resultMatrix.set(resultColumnIndex, resultRowIndex, value);
            }
        }
        return resultMatrix;
    }

    public DenseMatrix cholesky() {
        if (this.rowSize() != this.columnSize()) {
            throw new CardinalityException(this.rowSize(), this.columnSize());
        }
        int size = this.rowSize();
        DenseMatrix choleskyMatrix = new DenseMatrix(size, size);
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            for (int rowIndex_2 = 0; rowIndex_2 <= rowIndex; ++rowIndex_2) {
                double sum2 = 0.0;
                for (int columnIndex = 0; columnIndex < rowIndex_2; ++columnIndex) {
                    sum2 += choleskyMatrix.get(rowIndex, columnIndex) * choleskyMatrix.get(rowIndex_2, columnIndex);
                }
                double val = rowIndex == rowIndex_2 ? Math.sqrt(this.values[rowIndex][rowIndex] - sum2) : (this.values[rowIndex][rowIndex_2] - sum2) / choleskyMatrix.get(rowIndex_2, rowIndex_2);
                choleskyMatrix.set(rowIndex, rowIndex_2, val);
            }
            if (!Double.isNaN(choleskyMatrix.get(rowIndex, rowIndex))) continue;
            return null;
        }
        return choleskyMatrix.transpose();
    }

    public DenseMatrix inverse() {
        if (this.rowSize() != this.columnSize()) {
            throw new CardinalityException(this.rowSize(), this.columnSize());
        }
        int size = this.rowSize();
        DenseMatrix inverseMatrix = new DenseMatrix(size, size);
        for (int index = 0; index < size; ++index) {
            inverseMatrix.set(index, index, 1.0);
        }
        if (size == 1) {
            inverseMatrix.set(0, 0, 1.0 / this.get(0, 0));
            return inverseMatrix;
        }
        DenseMatrix copyMatrix = this.clone();
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            double mag2;
            int columnIndex;
            double mag = 0.0;
            int pivot = -1;
            for (columnIndex = rowIndex; columnIndex < size; ++columnIndex) {
                mag2 = Math.abs(copyMatrix.get(columnIndex, rowIndex));
                if (!(mag2 > mag)) continue;
                mag = mag2;
                pivot = columnIndex;
            }
            if (pivot == -1 || mag == 0.0) {
                return inverseMatrix;
            }
            if (pivot != rowIndex) {
                int columnIndex2;
                for (columnIndex2 = rowIndex; columnIndex2 < size; ++columnIndex2) {
                    double temp = copyMatrix.get(rowIndex, columnIndex2);
                    copyMatrix.set(rowIndex, columnIndex2, copyMatrix.get(pivot, columnIndex2));
                    copyMatrix.set(pivot, columnIndex2, temp);
                }
                for (columnIndex2 = 0; columnIndex2 < size; ++columnIndex2) {
                    double temp = inverseMatrix.get(rowIndex, columnIndex2);
                    inverseMatrix.set(rowIndex, columnIndex2, inverseMatrix.get(pivot, columnIndex2));
                    inverseMatrix.set(pivot, columnIndex2, temp);
                }
            }
            mag = copyMatrix.get(rowIndex, rowIndex);
            for (columnIndex = rowIndex; columnIndex < size; ++columnIndex) {
                copyMatrix.set(rowIndex, columnIndex, copyMatrix.get(rowIndex, columnIndex) / mag);
            }
            for (columnIndex = 0; columnIndex < size; ++columnIndex) {
                inverseMatrix.set(rowIndex, columnIndex, inverseMatrix.get(rowIndex, columnIndex) / mag);
            }
            for (int rowIndex_2 = 0; rowIndex_2 < size; ++rowIndex_2) {
                int columnIndex3;
                if (rowIndex == rowIndex_2) continue;
                mag2 = copyMatrix.get(rowIndex_2, rowIndex);
                for (columnIndex3 = rowIndex; columnIndex3 < size; ++columnIndex3) {
                    copyMatrix.set(rowIndex_2, columnIndex3, copyMatrix.get(rowIndex_2, columnIndex3) - mag2 * copyMatrix.get(rowIndex, columnIndex3));
                }
                for (columnIndex3 = 0; columnIndex3 < size; ++columnIndex3) {
                    inverseMatrix.set(rowIndex_2, columnIndex3, inverseMatrix.get(rowIndex_2, columnIndex3) - mag2 * inverseMatrix.get(rowIndex, columnIndex3));
                }
            }
        }
        return inverseMatrix;
    }

    @Override
    public boolean isRandomAccess() {
        return true;
    }

    @Override
    public Iterator<MatrixEntry> iterator() {
        return new DenseMatrixIterator();
    }

    public double[][] getValues() {
        return this.values;
    }

    private final class DenseMatrixEntry
    implements MatrixEntry {
        int row = 0;
        int column = -1;

        private DenseMatrixEntry() {
        }

        @Override
        public int row() {
            return this.row;
        }

        @Override
        public int column() {
            return this.column;
        }

        @Override
        public double get() {
            return DenseMatrix.this.get(this.row, this.column);
        }

        @Override
        public void set(double value) {
            DenseMatrix.this.set(this.row, this.column, value);
        }

        @Override
        public int rowPosition() {
            return this.row;
        }

        @Override
        public int columnPosition() {
            return this.column;
        }
    }

    private final class DenseMatrixIterator
    implements Iterator<MatrixEntry> {
        private final DenseMatrixEntry matrixEntry;
        private final int maxColumn;
        private final int maxRow;

        private DenseMatrixIterator() {
            this.matrixEntry = new DenseMatrixEntry();
            this.maxColumn = DenseMatrix.this.columnSize() - 1;
            this.maxRow = DenseMatrix.this.rowSize() - 1;
        }

        @Override
        public boolean hasNext() {
            return this.matrixEntry.row() < this.maxRow || this.matrixEntry.column() < this.maxColumn;
        }

        @Override
        public MatrixEntry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.matrixEntry.column < this.maxColumn) {
                ++this.matrixEntry.column;
            } else {
                ++this.matrixEntry.row;
                this.matrixEntry.column = 0;
            }
            return this.matrixEntry;
        }
    }
}

