/*
 * Decompiled with CFR 0.152.
 */
package net.librec.math.structure;

import java.util.Iterator;
import net.librec.math.algorithm.Randoms;
import net.librec.math.function.DoubleDoubleFunction;
import net.librec.math.function.DoubleFunction;
import net.librec.math.structure.AbstractVector;
import net.librec.math.structure.DenseMatrix;
import net.librec.math.structure.Vector;
import net.librec.math.structure.VectorAssigner;
import net.librec.math.structure.VectorBasedDenseVector;

public abstract class DenseVector
extends AbstractVector {
    public DenseVector(int cardinality) {
        super(cardinality);
    }

    public void init(double mean, double sigma) {
        this.assign((int index, double value) -> Randoms.gaussian(mean, sigma));
    }

    public void init() {
        this.assign((int index, double value) -> Randoms.uniform());
    }

    public void init(double range) {
        this.assign((int index, double value) -> Randoms.uniform(0.0, range));
    }

    public double aggregate(DoubleDoubleFunction aggregator, DoubleFunction map) {
        Iterator iterator;
        if (this.cardinality == 0) {
            return 0.0;
        }
        if (aggregator.isAssociativeAndCommutative() && aggregator.isLikeLeftMult() && this.cardinality > this.getNumEntries() && !map.isDensifying()) {
            return 0.0;
        }
        if (!map.isDensifying() && aggregator.isLikeRightPlus()) {
            iterator = this.iterator();
            if (!iterator.hasNext()) {
                return 0.0;
            }
        } else {
            iterator = this.iterator();
        }
        Vector.VectorEntry vectorEntry = (Vector.VectorEntry)iterator.next();
        double result = map.apply(vectorEntry.get());
        while (iterator.hasNext()) {
            vectorEntry = (Vector.VectorEntry)iterator.next();
            result = aggregator.apply(result, map.apply(vectorEntry.get()));
        }
        return result;
    }

    public DenseVector normalize() {
        return this.times(1.0 / Math.sqrt(this.getLengthSquared()));
    }

    public DenseVector normalize(double power) {
        return this.times(1.0 / this.norm(power));
    }

    public double dot(Vector vector) {
        double resultValue = 0.0;
        for (Vector.VectorEntry vectorEntry : vector) {
            resultValue += vectorEntry.get() * this.get(vectorEntry.index());
        }
        return resultValue;
    }

    public DenseMatrix outer(DenseVector vec) {
        DenseMatrix mat = new DenseMatrix(this.cardinality, vec.cardinality);
        for (int i = 0; i < mat.rowSize(); ++i) {
            for (int j = 0; j < mat.columnSize(); ++j) {
                mat.set(i, j, this.get(i) * vec.get(j));
            }
        }
        return mat;
    }

    public DenseVector clone() {
        try {
            DenseVector r = (DenseVector)super.clone();
            r.cardinality = this.cardinality;
            return r;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Can't happen");
        }
    }

    public DenseVector assign(DoubleFunction f) {
        for (int index = 0; index < this.cardinality(); ++index) {
            this.set(index, f.apply(this.get(index)));
        }
        return this;
    }

    public DenseVector assign(VectorAssigner vectorAssigner) {
        for (int index = 0; index < this.cardinality(); ++index) {
            this.set(index, vectorAssigner.getValue(index, this.get(index)));
        }
        return this;
    }

    public DenseVector plus(double value) {
        VectorBasedDenseVector resultVector = new VectorBasedDenseVector(this.cardinality());
        resultVector.assign((int rowIndex, double tempValue) -> this.get(rowIndex) + value);
        return resultVector;
    }

    public void plus(int index, double value) {
        this.set(index, value + this.get(index));
    }

    public abstract double[] getValues();

    public DenseVector plus(Vector vector) {
        VectorBasedDenseVector resultVector = new VectorBasedDenseVector(this.cardinality());
        for (Vector.VectorEntry vectorEntry : vector) {
            int index = vectorEntry.index();
            resultVector.set(index, this.get(index) + vectorEntry.get());
        }
        return resultVector;
    }

    public DenseVector minus(Vector vector) {
        VectorBasedDenseVector resultVector = new VectorBasedDenseVector(this.cardinality());
        for (Vector.VectorEntry vectorEntry : vector) {
            int index = vectorEntry.index();
            resultVector.set(index, this.get(index) - vectorEntry.get());
        }
        return resultVector;
    }

    public DenseVector times(double value) {
        VectorBasedDenseVector resultVector = new VectorBasedDenseVector(this.cardinality());
        resultVector.assign((int index, double tempValue) -> this.get(index) * value);
        return resultVector;
    }

    public DenseVector times(DenseVector vector) {
        VectorBasedDenseVector resultVector = new VectorBasedDenseVector(this.cardinality());
        resultVector.assign((int index, double tempValue) -> this.get(index) * vector.get(index));
        return resultVector;
    }

    @Override
    public boolean isDense() {
        return true;
    }

    @Override
    public boolean isSequentialAccess() {
        return true;
    }

    @Override
    public double getLookupCost() {
        return 1.0;
    }

    @Override
    public double getIteratorAdvanceCost() {
        return 1.0;
    }

    @Override
    public boolean isAddConstantTime() {
        return true;
    }

    @Override
    public int getNumEntries() {
        return this.cardinality();
    }
}

