/*
 * Decompiled with CFR 0.152.
 */
package net.librec.math.structure;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.librec.math.structure.DenseMatrix;
import net.librec.math.structure.DenseVector;
import net.librec.math.structure.Vector;

public class MatrixBasedDenseVector
extends DenseVector {
    private double[][] values;
    private int column;

    protected MatrixBasedDenseVector(int size) {
        super(size);
    }

    public MatrixBasedDenseVector(DenseMatrix matrix, int column) {
        super(matrix.rowSize());
        this.values = matrix.getValues();
        this.column = column;
    }

    @Override
    public MatrixBasedDenseVector clone() {
        return (MatrixBasedDenseVector)super.clone();
    }

    @Override
    public double[] getValues() {
        double[] tmp_values = new double[this.cardinality];
        for (Vector.VectorEntry vectorEntry : this) {
            tmp_values[vectorEntry.index()] = vectorEntry.get();
        }
        return tmp_values;
    }

    @Override
    public void set(int index, double value) {
        this.values[index][this.column] = value;
    }

    @Override
    public double get(int index) {
        return this.values[index][this.column];
    }

    @Override
    public Iterator<Vector.VectorEntry> iterator() {
        return new DenseVectorIterator();
    }

    private final class MatrixDenseVectorEntry
    implements Vector.VectorEntry {
        int index;

        public MatrixDenseVectorEntry(int index) {
            this.index = index;
        }

        @Override
        public double get() {
            return MatrixBasedDenseVector.this.values[this.index][MatrixBasedDenseVector.this.column];
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public int position() {
            return this.index;
        }

        @Override
        public void set(double value) {
            ((MatrixBasedDenseVector)MatrixBasedDenseVector.this).values[this.index][((MatrixBasedDenseVector)MatrixBasedDenseVector.this).column] = value;
        }
    }

    private final class DenseVectorIterator
    implements Iterator<Vector.VectorEntry> {
        private final MatrixDenseVectorEntry element;

        private DenseVectorIterator() {
            this.element = new MatrixDenseVectorEntry(-1);
        }

        @Override
        public boolean hasNext() {
            return this.element.index + 1 < MatrixBasedDenseVector.this.cardinality();
        }

        @Override
        public Vector.VectorEntry next() {
            if (this.element.index + 1 >= MatrixBasedDenseVector.this.cardinality()) {
                throw new NoSuchElementException();
            }
            ++this.element.index;
            return this.element;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

