/*
 * Decompiled with CFR 0.152.
 */
package net.librec.math.structure;

import java.util.Iterator;
import net.librec.math.structure.SequentialAccessSparseMatrix;
import net.librec.math.structure.SequentialSparseVector;
import net.librec.math.structure.Vector;

public class MatrixBasedSequentialSparseVector
extends SequentialSparseVector {
    private SequentialAccessSparseMatrix sparseMatrix;
    private int column;
    private int length;
    private int[] indices;

    private MatrixBasedSequentialSparseVector(int size) {
        super(size);
    }

    public MatrixBasedSequentialSparseVector(SequentialAccessSparseMatrix sparseMatrix, int column) {
        super(sparseMatrix.rowSize());
        this.sparseMatrix = sparseMatrix;
        this.column = column;
        this.indices = sparseMatrix.columnBasedRowIndices()[column];
        this.length = this.indices.length;
    }

    @Override
    public void setAtPosition(int position, double value) {
        this.sparseMatrix.setAtRowPosition(position, this.column, value);
    }

    @Override
    public double getAtPosition(int position) {
        return this.sparseMatrix.getAtRowPosition(position, this.column);
    }

    @Override
    public int getIndexAtPosition(int position) {
        return this.getIndices()[position];
    }

    @Override
    protected void reshape() {
        this.sparseMatrix.reshape();
    }

    @Override
    public int[] getIndices() {
        return this.sparseMatrix.columnBasedRowIndices()[this.column];
    }

    @Override
    public Vector.VectorEntry getVectorEntryAtPosition(int position) {
        MatrixBasedSparseVectorEntry matrixBasedSparseVectorEntry = new MatrixBasedSparseVectorEntry();
        matrixBasedSparseVectorEntry.position = position;
        return matrixBasedSparseVectorEntry;
    }

    @Override
    public int getNumEntries() {
        return this.length;
    }

    @Override
    @Deprecated
    public void set(int index, double value) {
        this.sparseMatrix.set(index, this.column, value);
    }

    @Override
    @Deprecated
    public double get(int index) {
        return this.sparseMatrix.get(index, this.column);
    }

    @Override
    public Iterator<Vector.VectorEntry> iterator() {
        return new MatrixBasedSequentialAccessIterator();
    }

    public final class MatrixBasedSparseVectorEntry
    implements Vector.VectorEntry {
        private int position = -1;

        void advanceOffset() {
            ++this.position;
        }

        int getNextOffset() {
            return this.position + 1;
        }

        @Override
        public double get() {
            return MatrixBasedSequentialSparseVector.this.sparseMatrix.getAtRowPosition(this.position, MatrixBasedSequentialSparseVector.this.column);
        }

        @Override
        public int index() {
            return MatrixBasedSequentialSparseVector.this.indices[this.position];
        }

        @Override
        public int position() {
            return this.position;
        }

        @Override
        public void set(double value) {
            MatrixBasedSequentialSparseVector.this.sparseMatrix.setAtRowPosition(this.position, MatrixBasedSequentialSparseVector.this.column, value);
        }
    }

    private final class MatrixBasedSequentialAccessIterator
    implements Iterator<Vector.VectorEntry> {
        private final MatrixBasedSparseVectorEntry vectorEntry;

        private MatrixBasedSequentialAccessIterator() {
            this.vectorEntry = new MatrixBasedSparseVectorEntry();
        }

        @Override
        public boolean hasNext() {
            return this.vectorEntry.getNextOffset() < MatrixBasedSequentialSparseVector.this.getNumEntries();
        }

        @Override
        public MatrixBasedSparseVectorEntry next() {
            this.vectorEntry.advanceOffset();
            return this.vectorEntry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

