/*
 * Decompiled with CFR 0.152.
 */
package net.librec.math.structure;

import it.unimi.dsi.fastutil.ints.Int2DoubleMap;
import it.unimi.dsi.fastutil.ints.Int2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.librec.math.structure.AbstractVector;
import net.librec.math.structure.Vector;

public class RandomAccessSparseVector
extends AbstractVector {
    private static final int INITIAL_CAPACITY = 11;
    private Int2DoubleOpenHashMap values;

    public RandomAccessSparseVector() {
        super(0);
    }

    public RandomAccessSparseVector(int cardinality) {
        this(cardinality, Math.min(cardinality, 11));
    }

    public RandomAccessSparseVector(int cardinality, int initialCapacity) {
        super(cardinality);
        this.values = new Int2DoubleOpenHashMap(initialCapacity, 0.5f);
    }

    public RandomAccessSparseVector(Vector other) {
        this(other.cardinality(), other.getNumEntries());
        for (Vector.VectorEntry e : other) {
            this.values.put(e.index(), e.get());
        }
    }

    private RandomAccessSparseVector(int cardinality, Int2DoubleOpenHashMap values) {
        super(cardinality);
        this.values = values;
    }

    public RandomAccessSparseVector(RandomAccessSparseVector other, boolean shallowCopy) {
        super(other.cardinality());
        this.values = shallowCopy ? other.values : other.values.clone();
    }

    @Override
    public String toString() {
        return this.sparseVectorToString();
    }

    @Override
    public boolean isDense() {
        return false;
    }

    @Override
    public boolean isSequentialAccess() {
        return false;
    }

    public RandomAccessSparseVector clone() {
        return new RandomAccessSparseVector(this.cardinality(), this.values.clone());
    }

    @Override
    public void set(int index, double value) {
        this.values.put(index, value);
    }

    @Override
    public double get(int index) {
        return this.values.getOrDefault(index, 0.0);
    }

    public boolean contains(int index) {
        return this.values.containsKey(index);
    }

    @Override
    public int getNumEntries() {
        return this.values.size();
    }

    @Override
    public double getLengthSquared() {
        return 0.0;
    }

    @Override
    public double getLookupCost() {
        return 1.0;
    }

    @Override
    public double getIteratorAdvanceCost() {
        return 1.375;
    }

    @Override
    public boolean isAddConstantTime() {
        return true;
    }

    @Override
    public Iterator<Vector.VectorEntry> iterator() {
        return new RandomAccessIterator();
    }

    public class RandomAccessEntry
    implements Vector.VectorEntry {
        final ObjectIterator<Int2DoubleMap.Entry> fastIterator;
        Int2DoubleMap.Entry entry;

        RandomAccessEntry(ObjectIterator<Int2DoubleMap.Entry> fastIterator) {
            this.fastIterator = fastIterator;
        }

        @Override
        public double get() {
            return this.entry.getDoubleValue();
        }

        @Override
        public int index() {
            return this.entry.getIntKey();
        }

        @Override
        public int position() {
            return this.index();
        }

        @Override
        public void set(double value) {
            this.entry.setValue(value);
        }
    }

    private final class RandomAccessIterator
    implements Iterator<Vector.VectorEntry> {
        final ObjectIterator<Int2DoubleMap.Entry> fastIterator;
        final RandomAccessEntry element;

        private RandomAccessIterator() {
            this.fastIterator = RandomAccessSparseVector.this.values.int2DoubleEntrySet().fastIterator();
            this.element = new RandomAccessEntry(this.fastIterator);
        }

        @Override
        public boolean hasNext() {
            return this.fastIterator.hasNext();
        }

        @Override
        public RandomAccessEntry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.element.entry = (Int2DoubleMap.Entry)this.fastIterator.next();
            return this.element;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

