/*
 * Decompiled with CFR 0.152.
 */
package net.librec.math.structure;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.io.Serializable;
import java.util.Iterator;
import net.librec.math.structure.AbstractMatrix;
import net.librec.math.structure.DataFrame;
import net.librec.math.structure.DataFrameIndex;
import net.librec.math.structure.MatrixEntry;
import net.librec.math.structure.SequentialAccessSparseMatrix;
import net.librec.math.structure.SequentialSparseVector;
import net.librec.math.structure.VectorBasedSequentialSparseVector;

public class RowSequentialAccessSparseMatrix
extends AbstractMatrix
implements Serializable {
    private static final long serialVersionUID = 8024536511172609930L;
    private VectorBasedSequentialSparseVector[] rowVectors;
    private int numEntries;
    private SequentialAccessSparseMatrix tmpSparseMatrix = null;

    public RowSequentialAccessSparseMatrix(int rows, int columns, VectorBasedSequentialSparseVector[] rowVectors) {
        this(rows, columns, rowVectors, false);
    }

    public RowSequentialAccessSparseMatrix(int rows, int columns, VectorBasedSequentialSparseVector[] vectors, boolean shallowCopy) {
        super(rows, columns);
        this.rowVectors = new VectorBasedSequentialSparseVector[rows];
        this.numEntries = 0;
        for (int row = 0; row < rows; ++row) {
            this.rowVectors[row] = shallowCopy ? vectors[row] : vectors[row].clone();
            this.numEntries += this.rowVectors[row].getNumEntries();
        }
    }

    public RowSequentialAccessSparseMatrix(int rows, int columns, DataFrame df, DataFrameIndex rowDataFrameIndex, int itemColumn, int valueColumn) {
        super(rows, columns);
        this.rowVectors = new VectorBasedSequentialSparseVector[rows];
        for (int rowIndex = 0; rowIndex < rows; ++rowIndex) {
            IntArrayList positions = rowDataFrameIndex.getIndices(rowIndex);
            IntArrayList indices = new IntArrayList(positions.size());
            DoubleArrayList doubleValues = new DoubleArrayList(positions.size());
            IntListIterator intListIterator = positions.iterator();
            while (intListIterator.hasNext()) {
                int position = (Integer)intListIterator.next();
                indices.add((int)((Integer)df.get(itemColumn, position)));
                doubleValues.add((double)((Double)df.get(valueColumn, position)));
            }
            this.rowVectors[rowIndex] = new VectorBasedSequentialSparseVector(columns, indices, doubleValues);
        }
    }

    private RowSequentialAccessSparseMatrix(int rows, int columns) {
        super(rows, columns);
        this.rowVectors = new VectorBasedSequentialSparseVector[rows];
        this.numEntries = 0;
    }

    public RowSequentialAccessSparseMatrix(SequentialAccessSparseMatrix matrix) {
        this(matrix.getRowMatrix());
    }

    public RowSequentialAccessSparseMatrix(RowSequentialAccessSparseMatrix matrix) {
        this(matrix.rowSize(), matrix.columnSize());
        this.numEntries = matrix.getNumEntries();
        for (int rowIndex = 0; rowIndex < matrix.rowSize(); ++rowIndex) {
            this.rowVectors[rowIndex] = new VectorBasedSequentialSparseVector(matrix.row(rowIndex));
        }
    }

    public RowSequentialAccessSparseMatrix(SequentialAccessSparseMatrix matrix, boolean shallowIndicesCopy) {
        this(matrix.getRowMatrix(), shallowIndicesCopy);
    }

    public RowSequentialAccessSparseMatrix(RowSequentialAccessSparseMatrix matrix, boolean shallowIndicesCopy) {
        this(matrix.rowSize(), matrix.columnSize());
        this.numEntries = matrix.getNumEntries();
        for (int rowIndex = 0; rowIndex < matrix.rowSize(); ++rowIndex) {
            this.rowVectors[rowIndex] = new VectorBasedSequentialSparseVector((VectorBasedSequentialSparseVector)matrix.row(rowIndex), shallowIndicesCopy);
        }
    }

    public RowSequentialAccessSparseMatrix(int rows, int columns, Table<Integer, Integer, ? extends Number> dataTable) {
        this(rows, columns);
        this.numEntries = dataTable.size();
        this.construct(dataTable, false);
    }

    public RowSequentialAccessSparseMatrix(int rows, int columns, Table<Integer, Integer, ? extends Number> dataTable, boolean transpose) {
        this(rows, columns);
        this.numEntries = dataTable.size();
        this.construct(dataTable, transpose);
    }

    private void construct(Table<Integer, Integer, ? extends Number> dataTable, boolean transpose) {
        if (transpose) {
            HashBasedTable<Integer, Integer, ? extends Number> colDataTable = HashBasedTable.create();
            for (Table.Cell<Integer, Integer, ? extends Number> cell : dataTable.cellSet()) {
                colDataTable.put(cell.getColumnKey(), cell.getRowKey(), (Number)cell.getValue().doubleValue());
            }
            dataTable = colDataTable;
        }
        for (int rowIndex = 0; rowIndex < this.rowSize(); ++rowIndex) {
            this.rowVectors[rowIndex] = dataTable.containsRow(rowIndex) ? new VectorBasedSequentialSparseVector(this.columnSize(), dataTable.row(rowIndex)) : new VectorBasedSequentialSparseVector(this.columnSize());
        }
    }

    public void reshape() {
        this.numEntries = 0;
        for (int rowIndex = 0; rowIndex < this.rowSize(); ++rowIndex) {
            this.rowVectors[rowIndex].reshape();
            this.numEntries += this.rowVectors[rowIndex].getNumEntries();
        }
    }

    @Override
    public RowSequentialAccessSparseMatrix clone() {
        return new RowSequentialAccessSparseMatrix(this.rowSize(), this.columnSize(), this.rowVectors, false);
    }

    public double mean() {
        double meanValue = 0.0;
        for (MatrixEntry matrixEntry : this) {
            meanValue += matrixEntry.get();
        }
        return meanValue / (double)this.getNumEntries();
    }

    @Override
    public double get(int row, int column) {
        return this.row(row).get(column);
    }

    public double getAtColumnPosition(int row, int columnPosition) {
        return this.row(row).getAtPosition(columnPosition);
    }

    @Override
    public void set(int row, int column, double value) {
        this.row(row).set(column, value);
    }

    public void setAtColumnPosition(int row, int columnPosition, double value) {
        this.row(row).setAtPosition(columnPosition, value);
    }

    @Override
    public int getNumEntries() {
        return this.numEntries;
    }

    @Override
    public Iterator<MatrixEntry> iterator() {
        return new SparseMatrixIterator();
    }

    @Override
    public SequentialSparseVector row(int row) {
        return this.rowVectors[row];
    }

    @Override
    public SequentialSparseVector column(int column) {
        if (this.tmpSparseMatrix == null) {
            this.tmpSparseMatrix = new SequentialAccessSparseMatrix(this);
        }
        return this.tmpSparseMatrix.column(column);
    }

    @Override
    public SequentialSparseVector viewRow(int row) {
        return this.rowVectors[row].clone();
    }

    @Override
    public SequentialSparseVector viewColumn(int column) {
        if (this.tmpSparseMatrix == null) {
            this.tmpSparseMatrix = new SequentialAccessSparseMatrix(this);
        }
        return this.tmpSparseMatrix.viewColumn(column);
    }

    @Override
    public boolean isRandomAccess() {
        return false;
    }

    public final class RowSequentialSparseMatrixEntry
    implements MatrixEntry {
        int row = 0;
        int columnPosition = -1;
        int matrixEntryPosition = 0;
        SequentialSparseVector tempVector = RowSequentialAccessSparseMatrix.access$200(RowSequentialAccessSparseMatrix.this)[0];

        private void advanceOffset() {
            ++this.matrixEntryPosition;
            if (this.columnPosition < this.tempVector.getNumEntries() - 1) {
                ++this.columnPosition;
            } else {
                ++this.row;
                this.columnPosition = 0;
                this.tempVector = RowSequentialAccessSparseMatrix.this.rowVectors[this.row];
                while (this.tempVector.getNumEntries() == 0) {
                    ++this.row;
                    this.tempVector = RowSequentialAccessSparseMatrix.this.rowVectors[this.row];
                }
            }
        }

        private int getMatrixEntryPosition() {
            return this.matrixEntryPosition;
        }

        @Override
        public int row() {
            return this.row;
        }

        @Override
        public int column() {
            return this.tempVector.getIndexAtPosition(this.columnPosition);
        }

        @Override
        public double get() {
            return this.tempVector.getAtPosition(this.columnPosition);
        }

        @Override
        public int columnPosition() {
            return this.columnPosition;
        }

        @Override
        public void set(double value) {
            this.tempVector.setAtPosition(this.columnPosition, value);
        }

        @Override
        public int rowPosition() {
            return this.row;
        }
    }

    public final class SparseMatrixIterator
    implements Iterator<MatrixEntry> {
        private final RowSequentialSparseMatrixEntry matrixEntry;

        public SparseMatrixIterator() {
            this.matrixEntry = new RowSequentialSparseMatrixEntry();
        }

        @Override
        public boolean hasNext() {
            return this.matrixEntry.getMatrixEntryPosition() < RowSequentialAccessSparseMatrix.this.getNumEntries();
        }

        @Override
        public RowSequentialSparseMatrixEntry next() {
            this.matrixEntry.advanceOffset();
            return this.matrixEntry;
        }
    }
}

