/*
 * Decompiled with CFR 0.152.
 */
package net.librec.math.structure;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.librec.math.structure.AbstractMatrix;
import net.librec.math.structure.DataFrame;
import net.librec.math.structure.DataFrameIndex;
import net.librec.math.structure.MatrixBasedSequentialSparseVector;
import net.librec.math.structure.MatrixEntry;
import net.librec.math.structure.RowSequentialAccessSparseMatrix;
import net.librec.math.structure.SequentialSparseVector;
import net.librec.math.structure.Vector;
import net.librec.math.structure.VectorBasedSequentialSparseVector;
import org.apache.commons.lang.ArrayUtils;

public class SequentialAccessSparseMatrix
extends AbstractMatrix
implements Serializable {
    private static final long serialVersionUID = 8024536511172609539L;
    private RowSequentialAccessSparseMatrix rowMatrix;
    private int[][] rowToColumnPositionMap;
    private int[][] columnToRowPositionMap;
    private int[][] columnIndices;

    private SequentialAccessSparseMatrix(int rows, int columns) {
        super(rows, columns);
    }

    public SequentialAccessSparseMatrix(int rows, int columns, Table<Integer, Integer, ? extends Number> dataTable) {
        this(rows, columns);
        this.rowMatrix = new RowSequentialAccessSparseMatrix(rows, columns, dataTable, false);
        this.constructColumnIndices(this.rowMatrix);
        this.constructMap();
    }

    public SequentialAccessSparseMatrix(RowSequentialAccessSparseMatrix rowMatrix) {
        this(rowMatrix.rowSize(), rowMatrix.columnSize());
        this.rowMatrix = rowMatrix.clone();
        this.constructColumnIndices(rowMatrix);
        this.constructMap();
    }

    public SequentialAccessSparseMatrix(SequentialAccessSparseMatrix otherMatrix) {
        this(otherMatrix.rowSize(), otherMatrix.columnSize());
        this.rowMatrix = otherMatrix.getRowMatrix().clone();
        this.columnIndices = net.librec.util.ArrayUtils.copy(otherMatrix.columnIndices);
        this.rowToColumnPositionMap = net.librec.util.ArrayUtils.copy(otherMatrix.rowToColumnPositionMap);
        this.columnToRowPositionMap = net.librec.util.ArrayUtils.copy(otherMatrix.columnToRowPositionMap);
    }

    public SequentialAccessSparseMatrix(int rows, int columns, DataFrame df, DataFrameIndex rowDataFrameIndex, int itemColumn, int valueColumn) {
        this(rows, columns);
        this.rowMatrix = new RowSequentialAccessSparseMatrix(rows, columns, df, rowDataFrameIndex, itemColumn, valueColumn);
        this.constructColumnIndices(this.rowMatrix);
        this.constructMap();
    }

    public SequentialAccessSparseMatrix(RowSequentialAccessSparseMatrix rowMatrix, boolean shallowIndicesCopy) {
        this(rowMatrix.rowSize(), rowMatrix.columnSize());
        this.rowMatrix = new RowSequentialAccessSparseMatrix(rowMatrix, shallowIndicesCopy);
        this.constructColumnIndices(rowMatrix);
        this.constructMap();
    }

    public SequentialAccessSparseMatrix(SequentialAccessSparseMatrix otherMatrix, boolean shallowIndicesCopy) {
        this(otherMatrix.rowSize(), otherMatrix.columnSize());
        this.rowMatrix = new RowSequentialAccessSparseMatrix(otherMatrix, shallowIndicesCopy);
        this.columnIndices = shallowIndicesCopy ? otherMatrix.columnIndices : net.librec.util.ArrayUtils.copy(otherMatrix.columnIndices);
        this.rowToColumnPositionMap = shallowIndicesCopy ? otherMatrix.rowToColumnPositionMap : net.librec.util.ArrayUtils.copy(otherMatrix.rowToColumnPositionMap);
        this.columnToRowPositionMap = shallowIndicesCopy ? otherMatrix.columnToRowPositionMap : net.librec.util.ArrayUtils.copy(otherMatrix.columnToRowPositionMap);
    }

    private void constructColumnIndices(RowSequentialAccessSparseMatrix rowMatrix) {
        IntArrayList[] columnIndicesList = new IntArrayList[rowMatrix.columnSize()];
        for (int columnIndex = 0; columnIndex < rowMatrix.columnSize(); ++columnIndex) {
            columnIndicesList[columnIndex] = new IntArrayList();
        }
        for (MatrixEntry matrixEntry : rowMatrix) {
            int rowIndex = matrixEntry.row();
            int columnIndex = matrixEntry.column();
            columnIndicesList[columnIndex].add(rowIndex);
        }
        this.columnIndices = new int[rowMatrix.columnSize()][];
        for (int columnIndex = 0; columnIndex < rowMatrix.columnSize(); ++columnIndex) {
            int size = columnIndicesList[columnIndex].size();
            this.columnIndices[columnIndex] = new int[size];
            Collections.sort(columnIndicesList[columnIndex]);
            for (int position = 0; position < size; ++position) {
                this.columnIndices[columnIndex][position] = columnIndicesList[columnIndex].getInt(position);
            }
        }
    }

    private void constructMap() {
        SequentialSparseVector tempRowVector;
        Int2ObjectOpenHashMap<Int2IntOpenHashMap> rowPositionMap = new Int2ObjectOpenHashMap<Int2IntOpenHashMap>();
        for (int rowIndex = 0; rowIndex < this.rowSize(); ++rowIndex) {
            tempRowVector = this.row(rowIndex);
            Int2IntOpenHashMap tempPositionMap = new Int2IntOpenHashMap();
            for (Object vectorEntry : tempRowVector) {
                tempPositionMap.put(vectorEntry.index(), vectorEntry.position());
            }
            rowPositionMap.put(rowIndex, tempPositionMap);
        }
        this.columnToRowPositionMap = new int[this.columnSize()][];
        for (int columnIndex = 0; columnIndex < this.columnSize(); ++columnIndex) {
            tempRowVector = this.column(columnIndex);
            this.columnToRowPositionMap[columnIndex] = new int[tempRowVector.getNumEntries()];
            for (Vector.VectorEntry vectorEntry : tempRowVector) {
                this.columnToRowPositionMap[columnIndex][vectorEntry.position()] = ((Int2IntOpenHashMap)rowPositionMap.get(vectorEntry.index())).get(columnIndex);
            }
        }
        Int2ObjectOpenHashMap<Int2IntOpenHashMap> columnPositionMap = new Int2ObjectOpenHashMap<Int2IntOpenHashMap>();
        for (int columnIndex = 0; columnIndex < this.columnSize(); ++columnIndex) {
            SequentialSparseVector tempColumnVector = this.column(columnIndex);
            Int2IntOpenHashMap tempPositionMap = new Int2IntOpenHashMap();
            for (Vector.VectorEntry vectorEntry : tempColumnVector) {
                tempPositionMap.put(vectorEntry.index(), vectorEntry.position());
            }
            columnPositionMap.put(columnIndex, tempPositionMap);
        }
        this.rowToColumnPositionMap = new int[this.rowSize()][];
        for (int rowIndex = 0; rowIndex < this.rowSize(); ++rowIndex) {
            SequentialSparseVector tempRowVector2 = this.row(rowIndex);
            this.rowToColumnPositionMap[rowIndex] = new int[tempRowVector2.getNumEntries()];
            for (Object vectorEntry : tempRowVector2) {
                this.rowToColumnPositionMap[rowIndex][vectorEntry.position()] = ((Int2IntOpenHashMap)columnPositionMap.get(vectorEntry.index())).get(rowIndex);
            }
        }
    }

    public double mean() {
        return this.rowMatrix.mean();
    }

    @Override
    public SequentialSparseVector row(int row) {
        return this.rowMatrix.row(row);
    }

    @Override
    public SequentialSparseVector column(int column) {
        return new MatrixBasedSequentialSparseVector(this, column);
    }

    @Override
    public SequentialSparseVector viewRow(int row) {
        return this.rowMatrix.viewRow(row);
    }

    @Override
    public SequentialSparseVector viewColumn(int column) {
        int columnLength = this.columnIndices[column].length;
        int[] indices = new int[columnLength];
        double[] values = new double[columnLength];
        for (int position = 0; position < columnLength; ++position) {
            indices[position] = this.columnIndices[column][position];
            int row = this.columnIndices[column][position];
            int columnPosition = this.columnToRowPositionMap[column][position];
            values[position] = this.getAtColumnPosition(row, columnPosition);
        }
        return new VectorBasedSequentialSparseVector(this.rowSize(), indices, values);
    }

    public void reshape() {
        this.rowMatrix.reshape();
        this.constructColumnIndices(this.rowMatrix);
        this.constructMap();
    }

    protected int[][] columnBasedRowIndices() {
        return this.columnIndices;
    }

    @Override
    public SequentialAccessSparseMatrix clone() {
        SequentialAccessSparseMatrix copyMatrix = new SequentialAccessSparseMatrix(this.rowSize(), this.columnSize());
        copyMatrix.rowMatrix = this.rowMatrix.clone();
        copyMatrix.columnIndices = net.librec.util.ArrayUtils.copy(this.columnIndices);
        copyMatrix.rowToColumnPositionMap = net.librec.util.ArrayUtils.copy(this.rowToColumnPositionMap);
        copyMatrix.columnToRowPositionMap = net.librec.util.ArrayUtils.copy(this.columnToRowPositionMap);
        return copyMatrix;
    }

    public RowSequentialAccessSparseMatrix getRowMatrix() {
        return this.rowMatrix;
    }

    @Override
    public double get(int row, int column) {
        return this.rowMatrix.get(row, column);
    }

    @Override
    public void set(int row, int column, double value) {
        this.rowMatrix.set(row, column, value);
    }

    public void setAtColumnPosition(int row, int columnPosition, double value) {
        this.rowMatrix.setAtColumnPosition(row, columnPosition, value);
    }

    public double getAtColumnPosition(int row, int columnPosition) {
        return this.rowMatrix.getAtColumnPosition(row, columnPosition);
    }

    public void setAtRowPosition(int rowPosition, int column, double value) {
        int columnPosition = this.columnToRowPositionMap[column][rowPosition];
        int row = this.columnIndices[column][rowPosition];
        this.rowMatrix.setAtColumnPosition(row, columnPosition, value);
    }

    public double getAtRowPosition(int rowPosition, int column) {
        int row = this.columnIndices[column][rowPosition];
        int columnPosition = this.columnToRowPositionMap[column][rowPosition];
        return this.rowMatrix.getAtColumnPosition(row, columnPosition);
    }

    @Deprecated
    public LoadingCache<Integer, List<Integer>> rowColumnsCache(String cacheSpec) {
        LoadingCache<Integer, List<Integer>> cache = CacheBuilder.from(cacheSpec).build(new CacheLoader<Integer, List<Integer>>(){

            @Override
            public List<Integer> load(Integer rowId) throws Exception {
                int[] itemIndexes = SequentialAccessSparseMatrix.this.row(rowId).getIndices();
                Integer[] inputBoxed = ArrayUtils.toObject(itemIndexes);
                List<Integer> itemList = Arrays.asList(inputBoxed);
                return itemList;
            }
        });
        return cache;
    }

    @Deprecated
    public LoadingCache<Integer, Set<Integer>> rowColumnsSetCache(String cacheSpec) {
        LoadingCache<Integer, Set<Integer>> cache = CacheBuilder.from(cacheSpec).build(new CacheLoader<Integer, Set<Integer>>(){

            @Override
            public Set<Integer> load(Integer rowId) throws Exception {
                int[] itemIndexes = SequentialAccessSparseMatrix.this.row(rowId).getIndices();
                Integer[] inputBoxed = ArrayUtils.toObject(itemIndexes);
                List<Integer> itemList = Arrays.asList(inputBoxed);
                return new HashSet<Integer>(itemList);
            }
        });
        return cache;
    }

    @Deprecated
    public LoadingCache<Integer, List<Integer>> columnRowsCache(String cacheSpec) {
        LoadingCache<Integer, List<Integer>> cache = CacheBuilder.from(cacheSpec).build(new CacheLoader<Integer, List<Integer>>(){

            @Override
            public List<Integer> load(Integer colId) throws Exception {
                int[] userIndexes = SequentialAccessSparseMatrix.this.column(colId).getIndices();
                Integer[] inputBoxed = ArrayUtils.toObject(userIndexes);
                List<Integer> userList = Arrays.asList(inputBoxed);
                return userList;
            }
        });
        return cache;
    }

    @Deprecated
    public Table<Integer, Integer, Double> getDataTable() {
        HashBasedTable<Integer, Integer, Double> res = HashBasedTable.create();
        for (MatrixEntry me : this) {
            res.put(me.row(), me.column(), me.get());
        }
        return res;
    }

    @Override
    public boolean isRandomAccess() {
        return false;
    }

    @Override
    public int getNumEntries() {
        return this.rowMatrix.getNumEntries();
    }

    @Override
    public Iterator<MatrixEntry> iterator() {
        return new SparseMatrixIterator();
    }

    public final class SequentialSparseMatrixEntry
    implements MatrixEntry {
        int row = 0;
        int columnPosition = -1;
        int matrixEntryPosition = 0;
        SequentialSparseVector tempVector = SequentialAccessSparseMatrix.access$200(SequentialAccessSparseMatrix.this).row(0);

        private void advanceOffset() {
            ++this.matrixEntryPosition;
            if (this.columnPosition < this.tempVector.getNumEntries() - 1) {
                ++this.columnPosition;
            } else {
                ++this.row;
                this.columnPosition = 0;
                this.tempVector = SequentialAccessSparseMatrix.this.rowMatrix.row(this.row);
                while (this.tempVector.getNumEntries() == 0) {
                    ++this.row;
                    this.tempVector = SequentialAccessSparseMatrix.this.rowMatrix.row(this.row);
                }
            }
        }

        private int getMatrixEntryPosition() {
            return this.matrixEntryPosition;
        }

        @Override
        public int row() {
            return this.row;
        }

        @Override
        public int column() {
            return this.tempVector.getIndexAtPosition(this.columnPosition);
        }

        @Override
        public double get() {
            return this.tempVector.getAtPosition(this.columnPosition);
        }

        @Override
        public int columnPosition() {
            return this.columnPosition;
        }

        @Override
        @Deprecated
        public void set(double value) {
            this.tempVector.setAtPosition(this.columnPosition, value);
        }

        @Override
        public int rowPosition() {
            return SequentialAccessSparseMatrix.this.rowToColumnPositionMap[this.row][this.columnPosition];
        }
    }

    public final class SparseMatrixIterator
    implements Iterator<MatrixEntry> {
        private final SequentialSparseMatrixEntry matrixEntry;

        public SparseMatrixIterator() {
            this.matrixEntry = new SequentialSparseMatrixEntry();
        }

        @Override
        public boolean hasNext() {
            return this.matrixEntry.getMatrixEntryPosition() < SequentialAccessSparseMatrix.this.getNumEntries();
        }

        @Override
        public SequentialSparseMatrixEntry next() {
            this.matrixEntry.advanceOffset();
            return this.matrixEntry;
        }
    }
}

