/*
 * Decompiled with CFR 0.152.
 */
package net.librec.math.structure;

import java.util.Iterator;
import net.librec.math.structure.AbstractVector;
import net.librec.math.structure.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SequentialSparseVector
extends AbstractVector {
    private static final Log LOG = LogFactory.getLog(AbstractVector.class);

    public SequentialSparseVector(int size) {
        super(size);
    }

    public SequentialSparseVector clone() {
        try {
            SequentialSparseVector r = (SequentialSparseVector)super.clone();
            r.cardinality = this.cardinality;
            return r;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Can't happen");
        }
    }

    public abstract void setAtPosition(int var1, double var2);

    public abstract double getAtPosition(int var1);

    public abstract int getIndexAtPosition(int var1);

    protected abstract void reshape();

    public abstract int[] getIndices();

    public abstract Vector.VectorEntry getVectorEntryAtPosition(int var1);

    public double dot(SequentialSparseVector thatVector) {
        double value = 0.0;
        Iterator thisIterator = this.iterator();
        Iterator thatIterator = thatVector.iterator();
        if (thisIterator.hasNext() && thatIterator.hasNext()) {
            Vector.VectorEntry thisVectorEntry = (Vector.VectorEntry)thisIterator.next();
            Vector.VectorEntry thatVectorEntry = (Vector.VectorEntry)thatIterator.next();
            while (thisIterator.hasNext() && thatIterator.hasNext()) {
                int thatIndex;
                int thisIndex = thisVectorEntry.index();
                if (thisIndex == (thatIndex = thatVectorEntry.index())) {
                    value += thisVectorEntry.get() * thatVectorEntry.get();
                    thisVectorEntry = (Vector.VectorEntry)thisIterator.next();
                    thatVectorEntry = (Vector.VectorEntry)thatIterator.next();
                    continue;
                }
                if (thisIndex < thatIndex) {
                    thisVectorEntry = (Vector.VectorEntry)thisIterator.next();
                    continue;
                }
                thatVectorEntry = (Vector.VectorEntry)thatIterator.next();
            }
        }
        return value;
    }

    @Override
    public double getIteratorAdvanceCost() {
        return 1.0;
    }

    @Override
    public boolean isAddConstantTime() {
        return false;
    }

    @Override
    public boolean isSequentialAccess() {
        return true;
    }

    @Override
    public double getLookupCost() {
        return Math.max(1L, Math.round(Math.log(this.getNumEntries()) / Math.log(2.0)));
    }

    @Override
    public boolean isDense() {
        return false;
    }
}

