/*
 * Decompiled with CFR 0.152.
 */
package net.librec.math.structure;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class SparseStringMatrix {
    private static final long serialVersionUID = 8024536511172609539L;
    protected int numRows;
    protected int numColumns;
    protected Table<Integer, Integer, ? extends String> dataTable;
    protected String[] rowData;
    protected int[] rowPtr;
    protected int[] colInd;
    protected String[] colData;
    protected int[] colPtr;
    protected int[] rowInd;
    protected Multimap<Integer, Integer> colMap;

    public SparseStringMatrix(int rows, int cols, Table<Integer, Integer, ? extends String> dT, Multimap<Integer, Integer> cM) {
        this.numRows = rows;
        this.numColumns = cols;
        this.colMap = cM;
        this.dataTable = dT;
        this.construct(this.dataTable, this.colMap);
    }

    public SparseStringMatrix(int rows, int cols, Table<Integer, Integer, ? extends String> dataTable) {
        this(rows, cols, dataTable, null);
    }

    private SparseStringMatrix(int rows, int cols) {
        this.numRows = rows;
        this.numColumns = cols;
    }

    public SparseStringMatrix(SparseStringMatrix mat) {
        this.numRows = mat.numRows;
        this.numColumns = mat.numColumns;
        this.copyCRS(mat.rowData, mat.rowPtr, mat.colInd);
        this.copyCCS(mat.colData, mat.colPtr, mat.rowInd);
    }

    private void copyCRS(String[] data, int[] ptr, int[] idx) {
        int i;
        this.rowData = new String[data.length];
        for (i = 0; i < this.rowData.length; ++i) {
            this.rowData[i] = data[i];
        }
        this.rowPtr = new int[ptr.length];
        for (i = 0; i < this.rowPtr.length; ++i) {
            this.rowPtr[i] = ptr[i];
        }
        this.colInd = new int[idx.length];
        for (i = 0; i < this.colInd.length; ++i) {
            this.colInd[i] = idx[i];
        }
    }

    private void copyCCS(String[] data, int[] ptr, int[] idx) {
        int i;
        this.colData = new String[data.length];
        for (i = 0; i < this.colData.length; ++i) {
            this.colData[i] = data[i];
        }
        this.colPtr = new int[ptr.length];
        for (i = 0; i < this.colPtr.length; ++i) {
            this.colPtr[i] = ptr[i];
        }
        this.rowInd = new int[idx.length];
        for (i = 0; i < this.rowInd.length; ++i) {
            this.rowInd[i] = idx[i];
        }
    }

    public SparseStringMatrix clone() {
        return new SparseStringMatrix(this);
    }

    public SparseStringMatrix transpose() {
        SparseStringMatrix tr = new SparseStringMatrix(this.numColumns, this.numRows);
        tr.copyCRS(this.rowData, this.rowPtr, this.colInd);
        tr.copyCCS(this.colData, this.colPtr, this.rowInd);
        return tr;
    }

    public int[] getRowPointers() {
        return this.rowPtr;
    }

    public int[] getColumnIndices() {
        return this.colInd;
    }

    private void construct(Table<Integer, Integer, ? extends String> dataTable, Multimap<Integer, Integer> columnStructure) {
        int i;
        int nnz = dataTable.size();
        this.rowPtr = new int[this.numRows + 1];
        this.colInd = new int[nnz];
        this.rowData = new String[nnz];
        int j = 0;
        for (i = 1; i <= this.numRows; ++i) {
            Set<Integer> cols = dataTable.row(i - 1).keySet();
            this.rowPtr[i] = this.rowPtr[i - 1] + cols.size();
            for (int col : cols) {
                this.colInd[j++] = col;
                if (col >= 0 && col < this.numColumns) continue;
                throw new IllegalArgumentException("colInd[" + j + "]=" + col + ", which is not a valid column index");
            }
            Arrays.sort(this.colInd, this.rowPtr[i - 1], this.rowPtr[i]);
        }
        this.colPtr = new int[this.numColumns + 1];
        this.rowInd = new int[nnz];
        this.colData = new String[nnz];
        j = 0;
        for (i = 1; i <= this.numColumns; ++i) {
            Collection<Integer> rows = columnStructure != null ? columnStructure.get(i - 1) : dataTable.column(i - 1).keySet();
            this.colPtr[i] = this.colPtr[i - 1] + rows.size();
            for (int row : rows) {
                this.rowInd[j++] = row;
                if (row >= 0 && row < this.numRows) continue;
                throw new IllegalArgumentException("rowInd[" + j + "]=" + row + ", which is not a valid row index");
            }
            Arrays.sort(this.rowInd, this.colPtr[i - 1], this.colPtr[i]);
        }
        for (Table.Cell<Integer, Integer, ? extends String> en : dataTable.cellSet()) {
            int col;
            int row = en.getRowKey();
            col = en.getColumnKey();
            String val = en.getValue().toString();
            this.set(row, col, val);
        }
    }

    public int numRows() {
        return this.numRows;
    }

    public int numColumns() {
        return this.numColumns;
    }

    public String[] getData() {
        return this.rowData;
    }

    public void set(int row, int column, String val) {
        int index = this.getCRSIndex(row, column);
        this.rowData[index] = val;
        index = this.getCCSIndex(row, column);
        this.colData[index] = val;
    }

    public void add(int row, int column, double val) {
        int index;
        int n = index = this.getCRSIndex(row, column);
        this.rowData[n] = this.rowData[n] + val;
        int n2 = index = this.getCCSIndex(row, column);
        this.colData[n2] = this.colData[n2] + val;
    }

    public String get(int row, int column) {
        int index = Arrays.binarySearch(this.colInd, this.rowPtr[row], this.rowPtr[row + 1], column);
        if (index >= 0) {
            return this.rowData[index];
        }
        return "0";
    }

    public LoadingCache<Integer, List<Integer>> columnRowsCache(String cacheSpec) {
        LoadingCache<Integer, List<Integer>> cache = CacheBuilder.from(cacheSpec).build(new CacheLoader<Integer, List<Integer>>(){

            @Override
            public List<Integer> load(Integer colId) throws Exception {
                return SparseStringMatrix.this.getRows(colId);
            }
        });
        return cache;
    }

    public int rowSize(int row) {
        int size = 0;
        for (int j = this.rowPtr[row]; j < this.rowPtr[row + 1]; ++j) {
            int col = this.colInd[j];
            if (this.get(row, col) == "0") continue;
            ++size;
        }
        return size;
    }

    public List<Integer> rows() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        block0: for (int row = 0; row < this.numRows; ++row) {
            for (int j = this.rowPtr[row]; j < this.rowPtr[row + 1]; ++j) {
                int col = this.colInd[j];
                if (this.get(row, col) == "0") continue;
                list.add(row);
                continue block0;
            }
        }
        return list;
    }

    public int columnSize(int col) {
        int size = 0;
        for (int j = this.colPtr[col]; j < this.colPtr[col + 1]; ++j) {
            int row = this.rowInd[j];
            String val = this.get(row, col);
            if (val == "0") continue;
            ++size;
        }
        return size;
    }

    public List<Integer> getRows(int col) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        if (col < this.numColumns) {
            for (int j = this.colPtr[col]; j < this.colPtr[col + 1]; ++j) {
                int row = this.rowInd[j];
                String val = this.get(row, col);
                if (val == "0") continue;
                res.add(row);
            }
        }
        return res;
    }

    public List<Integer> columns() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        block0: for (int col = 0; col < this.numColumns; ++col) {
            for (int j = this.colPtr[col]; j < this.colPtr[col + 1]; ++j) {
                int row = this.rowInd[j];
                String val = this.get(row, col);
                if (val == "0") continue;
                list.add(col);
                continue block0;
            }
        }
        return list;
    }

    public String matString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Dimension: ").append(this.numRows).append(" x ").append(this.numColumns).append("\n");
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numColumns; ++j) {
                sb.append(this.get(i, j));
                if (j >= this.numColumns - 1) continue;
                sb.append("\t");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private int getCRSIndex(int row, int col) {
        int i = Arrays.binarySearch(this.colInd, this.rowPtr[row], this.rowPtr[row + 1], col);
        if (i >= 0 && this.colInd[i] == col) {
            return i;
        }
        throw new IndexOutOfBoundsException("Entry (" + (row + 1) + ", " + (col + 1) + ") is not in the matrix structure");
    }

    private int getCCSIndex(int row, int col) {
        int i = Arrays.binarySearch(this.rowInd, this.colPtr[col], this.colPtr[col + 1], row);
        if (i >= 0 && this.rowInd[i] == row) {
            return i;
        }
        throw new IndexOutOfBoundsException("Entry (" + (row + 1) + ", " + (col + 1) + ") is not in the matrix structure");
    }
}

