/*
 * Decompiled with CFR 0.152.
 */
package net.librec.math.structure;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.librec.math.structure.DenseVector;
import net.librec.math.structure.Vector;

public class VectorBasedDenseVector
extends DenseVector {
    private double[] values;

    public VectorBasedDenseVector() {
        super(0);
    }

    public VectorBasedDenseVector(double[] values) {
        this(values, false);
    }

    public VectorBasedDenseVector(double[] values, boolean shallowCopy) {
        super(values.length);
        if (!shallowCopy) {
            this.values = new double[values.length];
            System.arraycopy(values, 0, this.values, 0, values.length);
        } else {
            this.values = values;
        }
        this.values = shallowCopy ? values : (double[])values.clone();
    }

    public VectorBasedDenseVector(VectorBasedDenseVector values, boolean shallowCopy) {
        this(values.values, shallowCopy);
    }

    public VectorBasedDenseVector(int cardinality) {
        super(cardinality);
        this.values = new double[cardinality];
    }

    public VectorBasedDenseVector(Vector vector) {
        super(vector.cardinality());
        this.values = new double[vector.cardinality()];
        for (Vector.VectorEntry vectorEntry : vector) {
            this.values[vectorEntry.index()] = vectorEntry.get();
        }
    }

    @Override
    public VectorBasedDenseVector clone() {
        return (VectorBasedDenseVector)super.clone();
    }

    @Override
    public double[] getValues() {
        return this.values;
    }

    @Override
    public Vector.VectorEntry getVectorEntry(int index) {
        return new DenseVectorEntry(index);
    }

    @Override
    public void set(int index, double value) {
        this.values[index] = value;
    }

    @Override
    public double get(int index) {
        return this.values[index];
    }

    @Override
    public Iterator<Vector.VectorEntry> iterator() {
        return new DenseVectorIterator();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof VectorBasedDenseVector) {
            return Arrays.equals(this.values, ((VectorBasedDenseVector)o).values);
        }
        return super.equals(o);
    }

    private final class DenseVectorEntry
    implements Vector.VectorEntry {
        int index;

        private DenseVectorEntry(int index) {
            this.index = index;
        }

        @Override
        public double get() {
            return VectorBasedDenseVector.this.values[this.index];
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public int position() {
            return this.index;
        }

        @Override
        public void set(double value) {
            ((VectorBasedDenseVector)VectorBasedDenseVector.this).values[this.index] = value;
        }
    }

    private final class DenseVectorIterator
    implements Iterator<Vector.VectorEntry> {
        private final DenseVectorEntry vectorEntry;

        private DenseVectorIterator() {
            this.vectorEntry = new DenseVectorEntry(-1);
        }

        @Override
        public boolean hasNext() {
            return this.vectorEntry.index + 1 < VectorBasedDenseVector.this.cardinality();
        }

        @Override
        public Vector.VectorEntry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.vectorEntry.index;
            return this.vectorEntry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

