/*
 * Decompiled with CFR 0.152.
 */
package net.librec.math.structure;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import net.librec.math.structure.AbstractVector;
import net.librec.math.structure.OrderedIntDoubleMapping;
import net.librec.math.structure.OrderedVectorElement;
import net.librec.math.structure.SequentialSparseVector;
import net.librec.math.structure.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VectorBasedSequentialSparseVector
extends SequentialSparseVector {
    private static final Log LOG = LogFactory.getLog(AbstractVector.class);
    private OrderedIntDoubleMapping values;

    public VectorBasedSequentialSparseVector(int cardinality) {
        super(cardinality);
        this.values = new OrderedIntDoubleMapping();
    }

    public VectorBasedSequentialSparseVector(int cardinality, int numActivesElement) {
        super(cardinality);
        this.values = new OrderedIntDoubleMapping(numActivesElement);
    }

    public VectorBasedSequentialSparseVector(Vector other) {
        super(other.cardinality());
        if (other.isSequentialAccess()) {
            ArrayList<Double> nonZeros = new ArrayList<Double>();
            for (Vector.VectorEntry e : other) {
                double value = e.get();
                if (value == 0.0 || value == Double.NaN) continue;
                nonZeros.add(value);
            }
            int[] indices = new int[nonZeros.size()];
            double[] doubleValues = new double[nonZeros.size()];
            for (int i = 0; i < nonZeros.size(); ++i) {
                indices[i] = i;
                doubleValues[i] = (Double)nonZeros.get(i);
            }
            this.values = new OrderedIntDoubleMapping(indices, doubleValues);
        } else {
            this.values = this.copySortedRandomAccessSparseVector(other);
        }
    }

    private OrderedIntDoubleMapping copySortedRandomAccessSparseVector(Vector other) {
        int entryCount = other.getNumEntries();
        Object[] sortableEntries = new OrderedVectorElement[entryCount];
        int elementIndex = 0;
        for (Vector.VectorEntry vectorEntry : other) {
            double value = vectorEntry.get();
            if (value == 0.0 || value == Double.NaN) continue;
            sortableEntries[elementIndex++] = new OrderedVectorElement(vectorEntry.index(), value);
        }
        if (!other.isSequentialAccess()) {
            Arrays.sort(sortableEntries);
        }
        int[] indices = new int[sortableEntries.length];
        double[] doubleValues = new double[sortableEntries.length];
        OrderedIntDoubleMapping values = new OrderedIntDoubleMapping(indices, doubleValues);
        for (int sortIndex = 0; sortIndex < sortableEntries.length; ++sortIndex) {
            values.setIndexAt(sortIndex, ((OrderedVectorElement)sortableEntries[sortIndex]).getIndex());
            values.setValueAt(sortIndex, ((OrderedVectorElement)sortableEntries[sortIndex]).getValue());
        }
        return values;
    }

    public VectorBasedSequentialSparseVector(int cardinality, Map<Integer, ? extends Number> mapVector) {
        this(cardinality, mapVector.size());
        int entryCount = mapVector.size();
        Object[] sortableEntries = new OrderedVectorElement[entryCount];
        int elementIndex = 0;
        for (Map.Entry<Integer, ? extends Number> mapEntry : mapVector.entrySet()) {
            sortableEntries[elementIndex++] = new OrderedVectorElement(mapEntry.getKey(), mapEntry.getValue().doubleValue());
        }
        Arrays.sort(sortableEntries);
        int[] indices = new int[sortableEntries.length];
        double[] doubleValues = new double[sortableEntries.length];
        for (int index = 0; index < sortableEntries.length; ++index) {
            indices[index] = ((OrderedVectorElement)sortableEntries[index]).getIndex();
            doubleValues[index] = ((OrderedVectorElement)sortableEntries[index]).getValue();
        }
        this.values = new OrderedIntDoubleMapping(indices, doubleValues);
    }

    public VectorBasedSequentialSparseVector(int cardinality, IntArrayList indices, DoubleArrayList doubleValues) {
        this(cardinality, indices.size());
        int entryCount = indices.size();
        Object[] sortableEntries = new OrderedVectorElement[entryCount];
        int elementIndex = 0;
        for (int index = 0; index < entryCount; ++index) {
            sortableEntries[elementIndex++] = new OrderedVectorElement(indices.getInt(index), doubleValues.getDouble(index));
        }
        Arrays.sort(sortableEntries);
        int[] tmpIndices = new int[sortableEntries.length];
        double[] tmpDoubleValues = new double[sortableEntries.length];
        for (int index = 0; index < sortableEntries.length; ++index) {
            tmpIndices[index] = ((OrderedVectorElement)sortableEntries[index]).getIndex();
            tmpDoubleValues[index] = ((OrderedVectorElement)sortableEntries[index]).getValue();
        }
        this.values = new OrderedIntDoubleMapping(tmpIndices, tmpDoubleValues);
    }

    public VectorBasedSequentialSparseVector(VectorBasedSequentialSparseVector other, boolean shallowIndicesCopy) {
        this(other.cardinality());
        int[] indices = shallowIndicesCopy ? other.values.getIndices() : (int[])other.values.getIndices().clone();
        double[] doublesValues = (double[])other.values.getValues().clone();
        this.values = new OrderedIntDoubleMapping(indices, doublesValues);
    }

    public VectorBasedSequentialSparseVector(VectorBasedSequentialSparseVector other) {
        this(other.cardinality());
        this.values = other.values.clone();
    }

    private VectorBasedSequentialSparseVector(int cardinality, OrderedIntDoubleMapping values) {
        this(cardinality);
        this.values = values;
    }

    public VectorBasedSequentialSparseVector(int cardinality, int[] indices, double[] values) {
        this(cardinality);
        this.values = new OrderedIntDoubleMapping(indices, values);
    }

    @Override
    public VectorBasedSequentialSparseVector clone() {
        return new VectorBasedSequentialSparseVector(this.cardinality(), this.values.clone());
    }

    @Override
    protected void reshape() {
        this.values.reshape();
    }

    @Override
    public int[] getIndices() {
        return this.values.getIndices();
    }

    @Override
    public String toString() {
        return this.sparseVectorToString();
    }

    @Override
    @Deprecated
    public Vector.VectorEntry getVectorEntry(int index) {
        return new AbstractVector.LocalVectorEntry(this, index);
    }

    @Override
    public Vector.VectorEntry getVectorEntryAtPosition(int position) {
        SparseVectorEntry vectorEntry = new SparseVectorEntry();
        vectorEntry.position = position;
        return vectorEntry;
    }

    @Override
    @Deprecated
    public void set(int index, double value) {
        this.values.set(index, value);
    }

    @Override
    @Deprecated
    public double get(int index) {
        return this.values.get(index);
    }

    @Override
    public void setAtPosition(int position, double value) {
        this.values.setValueAt(position, value);
    }

    @Override
    public double getAtPosition(int position) {
        return this.values.getValueAt(position);
    }

    @Override
    public int getIndexAtPosition(int position) {
        return this.values.indexAt(position);
    }

    @Override
    public int getNumEntries() {
        return this.values.getNumMappings();
    }

    @Override
    public Iterator<Vector.VectorEntry> iterator() {
        return new SequentialAccessIterator();
    }

    public final class SparseVectorEntry
    implements Vector.VectorEntry {
        private int position = -1;

        void advanceOffset() {
            ++this.position;
        }

        int getNextOffset() {
            return this.position + 1;
        }

        @Override
        public double get() {
            return VectorBasedSequentialSparseVector.this.values.getValues()[this.position];
        }

        @Override
        public int index() {
            return VectorBasedSequentialSparseVector.this.values.getIndices()[this.position];
        }

        @Override
        public int position() {
            return this.position;
        }

        @Override
        public void set(double value) {
            VectorBasedSequentialSparseVector.this.values.setValueAt(this.position, value);
        }
    }

    private final class SequentialAccessIterator
    implements Iterator<Vector.VectorEntry> {
        private final SparseVectorEntry vectorEntry;

        private SequentialAccessIterator() {
            this.vectorEntry = new SparseVectorEntry();
        }

        @Override
        public boolean hasNext() {
            return this.vectorEntry.getNextOffset() < VectorBasedSequentialSparseVector.this.values.getNumMappings();
        }

        @Override
        public SparseVectorEntry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.vectorEntry.advanceOffset();
            return this.vectorEntry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

