/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender;

import com.google.common.collect.BiMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.librec.common.LibrecException;
import net.librec.conf.Configuration;
import net.librec.data.DataModel;
import net.librec.job.progress.ProgressBar;
import net.librec.recommender.Recommender;
import net.librec.recommender.RecommenderContext;
import net.librec.recommender.item.ContextKeyValueEntry;
import net.librec.recommender.item.GenericRecommendedItem;
import net.librec.recommender.item.RecommendedItem;
import net.librec.recommender.item.RecommendedList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractRecommender
implements Recommender {
    protected final Log LOG = LogFactory.getLog(this.getClass());
    protected boolean isRanking;
    protected int topN;
    protected Configuration conf;
    protected RecommenderContext context;
    protected boolean earlyStop;
    protected static boolean verbose = true;
    protected double loss;
    protected double lastLoss = 0.0;
    protected boolean isBoldDriver;
    protected float decay;
    protected ProgressBar progressBar;
    public BiMap<String, Integer> userMappingData;
    public BiMap<String, Integer> itemMappingData;

    protected void setup() throws LibrecException {
        this.conf = this.context.getConf();
        this.isRanking = this.conf.getBoolean("rec.recommender.isranking");
        if (this.isRanking) {
            this.topN = this.conf.getInt("rec.recommender.ranking.topn", 10);
            if (this.topN <= 0) {
                throw new IndexOutOfBoundsException("rec.recommender.ranking.topn should be more than 0!");
            }
        }
        this.earlyStop = this.conf.getBoolean("rec.recommender.earlystop", false);
        verbose = this.conf.getBoolean("rec.recommender.verbose", true);
        this.userMappingData = this.getDataModel().getUserMappingData();
        this.itemMappingData = this.getDataModel().getItemMappingData();
        if (verbose) {
            this.progressBar = new ProgressBar(100.0, 100);
        }
    }

    protected abstract void trainModel() throws LibrecException;

    @Override
    public void train(RecommenderContext context) throws LibrecException {
        this.context = context;
        this.setup();
        this.LOG.info("Job Setup completed.");
        this.trainModel();
        this.LOG.info("Job Train completed.");
        this.cleanup();
    }

    protected void cleanup() throws LibrecException {
    }

    @Override
    public void loadModel(String filePath) {
    }

    @Override
    public void saveModel(String filePath) {
    }

    protected RecommenderContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(RecommenderContext context) {
        this.context = context;
    }

    @Override
    public DataModel getDataModel() {
        return this.context.getDataModel();
    }

    @Override
    public List<RecommendedItem> getRecommendedList(RecommendedList recommendedList) {
        if (recommendedList != null && recommendedList.size() > 0) {
            ArrayList<RecommendedItem> userItemList = new ArrayList<RecommendedItem>();
            Iterator<ContextKeyValueEntry> recommendedEntryIter = recommendedList.iterator();
            if (this.userMappingData != null && this.userMappingData.size() > 0 && this.itemMappingData != null && this.itemMappingData.size() > 0) {
                BiMap<Integer, String> userMappingInverse = this.userMappingData.inverse();
                BiMap<Integer, String> itemMappingInverse = this.itemMappingData.inverse();
                while (recommendedEntryIter.hasNext()) {
                    ContextKeyValueEntry contextKeyValueEntry = recommendedEntryIter.next();
                    if (contextKeyValueEntry == null) continue;
                    String userId = (String)userMappingInverse.get(contextKeyValueEntry.getContextIdx());
                    String itemId = (String)itemMappingInverse.get(contextKeyValueEntry.getKey());
                    if (!StringUtils.isNotBlank(userId) || !StringUtils.isNotBlank(itemId)) continue;
                    userItemList.add(new GenericRecommendedItem(userId, itemId, contextKeyValueEntry.getValue()));
                }
                return userItemList;
            }
        }
        return null;
    }

    protected boolean isConverged(int iter) throws LibrecException {
        float delta_loss = (float)(this.lastLoss - this.loss);
        if (verbose) {
            String recName = this.getClass().getSimpleName();
            String info = recName + " iter " + iter + ": loss = " + this.loss + ", delta_loss = " + delta_loss;
            this.LOG.info(info);
        }
        if (Double.isNaN(this.loss) || Double.isInfinite(this.loss)) {
            throw new LibrecException("Loss = NaN or Infinity: current settings does not fit the recommender! Change the settings and try again!");
        }
        return (double)Math.abs(delta_loss) < 1.0E-5;
    }

    public void updateProgress(int currentPoint) {
        if (verbose) {
            this.conf.setInt("train.current.progress", currentPoint);
            this.progressBar.showBarByPoint(this.conf.getInt("train.current.progress").intValue());
        }
    }
}

