/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender;

import net.librec.common.LibrecException;
import net.librec.recommender.MatrixRecommender;

public abstract class MatrixProbabilisticGraphicalRecommender
extends MatrixRecommender {
    protected int numUsers;
    protected int numItems;
    protected int numIterations;
    protected int burnIn;
    protected int numStats = 0;
    protected int sampleLag;

    @Override
    protected void setup() throws LibrecException {
        super.setup();
        this.numIterations = this.conf.getInt("rec.iterator.maximum", 1000);
        this.numUsers = this.trainMatrix.rowSize();
        this.numItems = this.trainMatrix.columnSize();
        this.burnIn = this.conf.getInt("rec.pgm.burnin", 100);
        this.sampleLag = this.conf.getInt("rec.pgm.samplelag", 10);
    }

    @Override
    protected void trainModel() throws LibrecException {
        for (int iter = 1; iter <= this.numIterations; ++iter) {
            this.eStep();
            this.mStep();
            if (iter <= this.burnIn || iter % this.sampleLag != 0) continue;
            this.readoutParams();
            this.estimateParams();
            if (this.isConverged(iter) && this.earlyStop) break;
        }
        this.estimateParams();
    }

    @Override
    protected boolean isConverged(int iter) {
        return false;
    }

    protected abstract void eStep();

    protected abstract void mStep();

    protected void readoutParams() {
    }

    protected void estimateParams() {
    }
}

