/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.librec.common.LibrecException;
import net.librec.data.structure.AbstractBaseDataEntry;
import net.librec.data.structure.BaseDataList;
import net.librec.data.structure.BaseRankingDataEntry;
import net.librec.data.structure.BaseRatingDataEntry;
import net.librec.data.structure.LibrecDataList;
import net.librec.math.structure.DataSet;
import net.librec.math.structure.MatrixEntry;
import net.librec.math.structure.SequentialAccessSparseMatrix;
import net.librec.recommender.AbstractRecommender;
import net.librec.recommender.item.KeyValue;
import net.librec.recommender.item.RecommendedList;

public abstract class MatrixRecommender
extends AbstractRecommender {
    protected SequentialAccessSparseMatrix trainMatrix;
    protected SequentialAccessSparseMatrix testMatrix;
    protected SequentialAccessSparseMatrix validMatrix;
    protected int numUsers;
    protected int numItems;
    protected int numRates;
    protected double maxRate;
    protected double minRate;
    protected static List<Double> ratingScale;
    protected double globalMean;

    @Override
    protected void setup() throws LibrecException {
        super.setup();
        this.trainMatrix = (SequentialAccessSparseMatrix)this.getDataModel().getTrainDataSet();
        this.testMatrix = (SequentialAccessSparseMatrix)this.getDataModel().getTestDataSet();
        this.validMatrix = (SequentialAccessSparseMatrix)this.getDataModel().getValidDataSet();
        this.numUsers = this.trainMatrix.rowSize();
        this.numItems = this.trainMatrix.columnSize();
        this.numRates = this.trainMatrix.size();
        HashSet<Double> ratingSet = new HashSet<Double>();
        for (MatrixEntry matrixEntry : this.trainMatrix) {
            ratingSet.add(matrixEntry.get());
        }
        ratingScale = new ArrayList<Double>(ratingSet);
        Collections.sort(ratingScale);
        this.maxRate = Collections.max(ratingScale);
        this.minRate = Collections.min(ratingScale);
        if (this.minRate == this.maxRate) {
            this.minRate = 0.0;
        }
        this.globalMean = this.trainMatrix.mean();
        int[] numDroppedItemsArray = new int[this.numUsers];
        int maxNumTestItemsByUser = 0;
        for (int userIdx = 0; userIdx < this.numUsers; ++userIdx) {
            numDroppedItemsArray[userIdx] = this.numItems - this.trainMatrix.row(userIdx).getNumEntries();
            int numTestItemsByUser = this.testMatrix.row(userIdx).getNumEntries();
            maxNumTestItemsByUser = maxNumTestItemsByUser < numTestItemsByUser ? numTestItemsByUser : maxNumTestItemsByUser;
        }
        int[] itemPurchasedCount = new int[this.numItems];
        for (int itemIdx = 0; itemIdx < this.numItems; ++itemIdx) {
            itemPurchasedCount[itemIdx] = this.trainMatrix.column(itemIdx).getNumEntries() + this.testMatrix.column(itemIdx).getNumEntries();
        }
        this.conf.setInts("rec.eval.auc.dropped.num", numDroppedItemsArray);
        this.conf.setInt("rec.eval.key.test.max.num", maxNumTestItemsByUser);
        this.conf.setInt("rec.eval.item.num", this.testMatrix.columnSize());
        this.conf.setInts("rec.eval.item.purchase.num", itemPurchasedCount);
    }

    @Override
    public RecommendedList recommendRank() throws LibrecException {
        BaseDataList<AbstractBaseDataEntry> librecDataList = new BaseDataList<AbstractBaseDataEntry>();
        for (int userIdx = 0; userIdx < this.numUsers; ++userIdx) {
            BaseRankingDataEntry baseRankingDataEntry = new BaseRankingDataEntry(userIdx);
            librecDataList.addDataEntry(baseRankingDataEntry);
        }
        return this.recommendRank(librecDataList);
    }

    @Override
    public RecommendedList recommendRank(LibrecDataList<AbstractBaseDataEntry> dataList) throws LibrecException {
        this.LOG.info("begin recommend");
        int numDataEntries = dataList.size();
        RecommendedList recommendedList = new RecommendedList(this.numUsers);
        ArrayList<Integer> contextList = new ArrayList<Integer>();
        for (int contextIdx2 = 0; contextIdx2 < numDataEntries; ++contextIdx2) {
            contextList.add(contextIdx2);
            recommendedList.addList(new ArrayList<KeyValue<Integer, Double>>());
        }
        contextList.parallelStream().forEach(contextIdx -> {
            BaseRankingDataEntry baseRankingDataEntry = (BaseRankingDataEntry)dataList.getDataEntry((int)contextIdx);
            int userIdx = baseRankingDataEntry.getUserId();
            int[] items = this.trainMatrix.row(userIdx).getIndices();
            ArrayList<KeyValue<Integer, Double>> itemValueList = new ArrayList<KeyValue<Integer, Double>>(this.numItems);
            int trainItemIndex = 0;
            for (int itemIdx = 0; itemIdx < this.numItems; ++itemIdx) {
                if (trainItemIndex < items.length && items[trainItemIndex] == itemIdx) {
                    ++trainItemIndex;
                    continue;
                }
                double predictRating = 0.0;
                try {
                    predictRating = this.predict(userIdx, itemIdx);
                }
                catch (LibrecException e) {
                    System.out.println(userIdx + ", " + itemIdx + ": " + predictRating);
                    e.printStackTrace();
                }
                catch (Exception e) {
                    System.out.println(userIdx + ", " + itemIdx + ": " + predictRating);
                    e.printStackTrace();
                }
                if (Double.isNaN(predictRating)) continue;
                itemValueList.add(new KeyValue<Integer, Double>(itemIdx, predictRating));
            }
            recommendedList.setList((int)contextIdx, (List<KeyValue<Integer, Double>>)itemValueList);
            recommendedList.topNRankByIndex((int)contextIdx, this.topN);
        });
        if (recommendedList.size() == 0) {
            throw new IndexOutOfBoundsException("No item is recommended, there is something error in the recommendation algorithm! Please check it!");
        }
        this.LOG.info("end recommend");
        return recommendedList;
    }

    @Override
    public RecommendedList recommendRating(DataSet predictDataSet) throws LibrecException {
        SequentialAccessSparseMatrix predictMatrix = (SequentialAccessSparseMatrix)predictDataSet;
        BaseDataList<AbstractBaseDataEntry> librecDataList = new BaseDataList<AbstractBaseDataEntry>();
        for (int userIdx = 0; userIdx < this.numUsers; ++userIdx) {
            int[] itemIdsArray = predictMatrix.row(userIdx).getIndices();
            BaseRatingDataEntry baseRatingDataEntry = new BaseRatingDataEntry(userIdx, itemIdsArray);
            librecDataList.addDataEntry(baseRatingDataEntry);
        }
        return this.recommendRating(librecDataList);
    }

    @Override
    public RecommendedList recommendRating(LibrecDataList<AbstractBaseDataEntry> dataList) throws LibrecException {
        int numDataEntries = dataList.size();
        RecommendedList recommendedList = new RecommendedList(numDataEntries);
        for (int contextIdx = 0; contextIdx < numDataEntries; ++contextIdx) {
            int[] itemIdsArray;
            recommendedList.addList(new ArrayList<KeyValue<Integer, Double>>());
            BaseRatingDataEntry baseRatingDataEntry = (BaseRatingDataEntry)dataList.getDataEntry(contextIdx);
            int userIdx = baseRatingDataEntry.getUserId();
            for (int itemIdx : itemIdsArray = baseRatingDataEntry.getItemIdsArray()) {
                double predictRating = this.predict(userIdx, itemIdx, true);
                if (Double.isNaN(predictRating)) {
                    predictRating = this.globalMean;
                }
                recommendedList.add(contextIdx, itemIdx, predictRating);
            }
        }
        return recommendedList;
    }

    protected abstract double predict(int var1, int var2) throws LibrecException;

    protected double predict(int userIdx, int itemIdx, boolean bound) throws LibrecException {
        double predictRating = this.predict(userIdx, itemIdx);
        if (bound) {
            if (predictRating > this.maxRate) {
                predictRating = this.maxRate;
            } else if (predictRating < this.minRate) {
                predictRating = this.minRate;
            }
        }
        return predictRating;
    }
}

