/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.cf;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.librec.annotation.ModelData;
import net.librec.common.LibrecException;
import net.librec.math.structure.DenseVector;
import net.librec.math.structure.SequentialAccessSparseMatrix;
import net.librec.math.structure.SequentialSparseVector;
import net.librec.math.structure.SymmMatrix;
import net.librec.math.structure.Vector;
import net.librec.math.structure.VectorBasedDenseVector;
import net.librec.recommender.MatrixRecommender;
import net.librec.util.Lists;

@ModelData(value={"isRanking", "knn", "itemMeans", "trainMatrix", "similarityMatrix"})
public class ItemKNNRecommender
extends MatrixRecommender {
    private int knn;
    private DenseVector itemMeans;
    private SymmMatrix similarityMatrix;
    private List<Map.Entry<Integer, Double>>[] itemSimilarityList;
    private List<Integer> itemList;

    @Override
    protected void setup() throws LibrecException {
        super.setup();
        this.knn = this.conf.getInt("rec.neighbors.knn.number", 50);
        this.similarityMatrix = this.context.getSimilarity().getSimilarityMatrix();
    }

    @Override
    protected void trainModel() throws LibrecException {
        this.itemMeans = new VectorBasedDenseVector(this.numItems);
        double globalMean = this.trainMatrix.mean();
        this.itemList = new ArrayList<Integer>();
        for (int itemIndex2 = 0; itemIndex2 < this.numItems; ++itemIndex2) {
            this.itemList.add(itemIndex2);
        }
        this.itemList.parallelStream().forEach(itemIndex -> {
            SequentialSparseVector itemRatingVector = this.trainMatrix.column((int)itemIndex);
            this.itemMeans.set((int)itemIndex, itemRatingVector.getNumEntries() > 0 ? itemRatingVector.mean() : globalMean);
        });
        this.createItemSimilarityList();
    }

    @Override
    public double predict(int userIdx, int itemIdx) throws LibrecException {
        List<Map.Entry<Integer, Double>> simList = this.itemSimilarityList[itemIdx];
        SequentialSparseVector itemRatingVector = this.trainMatrix.row(userIdx);
        int itemRatingSize = itemRatingVector.getNumEntries();
        int simItemSize = simList.size();
        if (itemRatingSize == 0 || simItemSize == 0) {
            return this.isRanking ? 0.0 : this.globalMean;
        }
        double predictValue = 0.0;
        double simSum = 0.0;
        int itemRatingPosition = 0;
        int simItemPosition = 0;
        while (simItemPosition < simItemSize && itemRatingPosition < itemRatingSize) {
            Map.Entry<Integer, Double> simUserEntry = simList.get(simItemPosition);
            int ratingItemIndex = itemRatingVector.getIndexAtPosition(itemRatingPosition);
            int simItemIndex = simUserEntry.getKey();
            if (simItemIndex == ratingItemIndex) {
                double sim = simUserEntry.getValue();
                if (this.isRanking) {
                    predictValue += sim;
                } else if (sim > 0.0) {
                    predictValue += sim * (itemRatingVector.getAtPosition(itemRatingPosition) - this.itemMeans.get(simItemIndex));
                    simSum += sim;
                }
                ++simItemPosition;
                ++itemRatingPosition;
                continue;
            }
            if (simItemIndex < ratingItemIndex) {
                ++simItemPosition;
                continue;
            }
            ++itemRatingPosition;
        }
        if (this.isRanking) {
            return predictValue;
        }
        return predictValue > 0.0 ? this.itemMeans.get(userIdx) + predictValue / simSum : this.globalMean;
    }

    public void createItemSimilarityList() {
        this.itemSimilarityList = new ArrayList[this.numItems];
        SequentialAccessSparseMatrix simMatrix = this.similarityMatrix.toSparseMatrix();
        this.itemList.parallelStream().forEach(itemIndex -> {
            SequentialSparseVector similarityVector = simMatrix.row((int)itemIndex);
            this.itemSimilarityList[itemIndex.intValue()] = new ArrayList<Map.Entry<Integer, Double>>(similarityVector.size());
            for (Vector.VectorEntry simVectorEntry : similarityVector) {
                this.itemSimilarityList[itemIndex].add(new AbstractMap.SimpleImmutableEntry<Integer, Double>(simVectorEntry.index(), simVectorEntry.get()));
            }
            this.itemSimilarityList[itemIndex.intValue()] = Lists.sortListTopK(this.itemSimilarityList[itemIndex], true, this.knn);
            Lists.sortListByKey(this.itemSimilarityList[itemIndex], false);
        });
    }
}

