/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.cf;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.librec.annotation.ModelData;
import net.librec.common.LibrecException;
import net.librec.math.structure.DenseVector;
import net.librec.math.structure.SequentialAccessSparseMatrix;
import net.librec.math.structure.SequentialSparseVector;
import net.librec.math.structure.SymmMatrix;
import net.librec.math.structure.Vector;
import net.librec.math.structure.VectorBasedDenseVector;
import net.librec.recommender.MatrixRecommender;
import net.librec.util.Lists;

@ModelData(value={"isRanking", "knn", "userMeans", "trainMatrix", "similarityMatrix"})
public class UserKNNRecommender
extends MatrixRecommender {
    private int knn;
    private DenseVector userMeans;
    private SymmMatrix similarityMatrix;
    private List<Map.Entry<Integer, Double>>[] userSimilarityList;
    private List<Integer> userList;

    @Override
    protected void setup() throws LibrecException {
        super.setup();
        this.knn = this.conf.getInt("rec.neighbors.knn.number");
        this.similarityMatrix = this.context.getSimilarity().getSimilarityMatrix();
    }

    @Override
    protected void trainModel() throws LibrecException {
        this.userMeans = new VectorBasedDenseVector(this.numUsers);
        this.userList = new ArrayList<Integer>(this.numUsers);
        for (int userIndex2 = 0; userIndex2 < this.numUsers; ++userIndex2) {
            this.userList.add(userIndex2);
        }
        this.userList.parallelStream().forEach(userIndex -> {
            SequentialSparseVector userRatingVector = this.trainMatrix.row((int)userIndex);
            this.userMeans.set((int)userIndex, userRatingVector.getNumEntries() > 0 ? userRatingVector.mean() : this.globalMean);
        });
        this.createUserSimilarityList();
    }

    @Override
    public double predict(int userIdx, int itemIdx) throws LibrecException {
        List<Map.Entry<Integer, Double>> simList = this.userSimilarityList[userIdx];
        double predictValue = 0.0;
        double simSum = 0.0;
        SequentialSparseVector userRatingVector = this.trainMatrix.column(itemIdx);
        int userRatingPosition = 0;
        int simUserPosition = 0;
        int userRatingSize = userRatingVector.getNumEntries();
        int simUserSize = simList.size();
        while (simUserPosition < simUserSize && userRatingPosition < userRatingSize) {
            Map.Entry<Integer, Double> simUserEntry = simList.get(simUserPosition);
            int ratingUserIndex = userRatingVector.getIndexAtPosition(userRatingPosition);
            int simUserIndex = simUserEntry.getKey();
            if (simUserIndex == ratingUserIndex) {
                double sim = simUserEntry.getValue();
                if (this.isRanking) {
                    predictValue += sim;
                } else if (sim > 0.0) {
                    predictValue += sim * (userRatingVector.getAtPosition(userRatingPosition) - this.userMeans.get(simUserIndex));
                    simSum += sim;
                }
                ++simUserPosition;
                ++userRatingPosition;
                continue;
            }
            if (simUserIndex < ratingUserIndex) {
                ++simUserPosition;
                continue;
            }
            ++userRatingPosition;
        }
        if (this.isRanking) {
            return predictValue;
        }
        return predictValue > 0.0 ? this.userMeans.get(userIdx) + predictValue / simSum : this.globalMean;
    }

    private void createUserSimilarityList() {
        this.userSimilarityList = new ArrayList[this.numUsers];
        SequentialAccessSparseMatrix simMatrix = this.similarityMatrix.toSparseMatrix();
        this.userList.parallelStream().forEach(userIndex -> {
            SequentialSparseVector similarityVector = simMatrix.row((int)userIndex);
            this.userSimilarityList[userIndex.intValue()] = new ArrayList<Map.Entry<Integer, Double>>(similarityVector.size());
            for (Vector.VectorEntry simVectorEntry : similarityVector) {
                this.userSimilarityList[userIndex].add(new AbstractMap.SimpleImmutableEntry<Integer, Double>(simVectorEntry.index(), simVectorEntry.get()));
            }
            this.userSimilarityList[userIndex.intValue()] = Lists.sortListTopK(this.userSimilarityList[userIndex], true, this.knn);
            Lists.sortListByKey(this.userSimilarityList[userIndex], false);
        });
    }
}

