/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.cf.ranking;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.librec.annotation.ModelData;
import net.librec.common.LibrecException;
import net.librec.math.algorithm.Maths;
import net.librec.math.algorithm.Randoms;
import net.librec.math.structure.DenseVector;
import net.librec.math.structure.VectorBasedDenseVector;
import net.librec.recommender.MatrixFactorizationRecommender;
import org.apache.commons.lang.ArrayUtils;

@ModelData(value={"isRanking", "cofiset", "userFactors", "itemFactors", "itemBiases"})
public class CoFiSetRecommender
extends MatrixFactorizationRecommender {
    protected double regBias;
    protected VectorBasedDenseVector itemBiases;
    protected int pSetSize;
    protected int aSetSize;
    private List<Set<Integer>> userItemsSet;

    @Override
    protected void setup() throws LibrecException {
        super.setup();
        this.pSetSize = this.conf.getInt("rec.presence.size", 1);
        this.aSetSize = this.conf.getInt("rec.absence.size", 1);
        this.regBias = this.conf.getDouble("rec.bias.regularization", 0.01);
        this.itemBiases = new VectorBasedDenseVector(this.numItems);
        this.itemBiases.init(this.initMean, this.initStd);
        this.userItemsSet = new ArrayList<Set<Integer>>();
        for (int userIdx = 0; userIdx < this.numUsers; ++userIdx) {
            int[] itemIndexes = this.trainMatrix.row(userIdx).getIndices();
            Integer[] inputBoxed = ArrayUtils.toObject(itemIndexes);
            List<Integer> itemList = Arrays.asList(inputBoxed);
            this.userItemsSet.add(new HashSet<Integer>(itemList));
        }
    }

    @Override
    protected void trainModel() throws LibrecException {
        for (int iter = 1; iter <= this.numIterations; ++iter) {
            this.loss = 0.0;
            for (int iter_rand = 0; iter_rand < this.numUsers; ++iter_rand) {
                double oldBiasValue;
                double oldFactorValue;
                int userIdx = Randoms.uniform(this.numUsers);
                int[] itemIndexes = this.trainMatrix.row(userIdx).getIndices();
                Integer[] inputBoxed = ArrayUtils.toObject(itemIndexes);
                List<Integer> allPresenceItems = Arrays.asList(inputBoxed);
                if (allPresenceItems.size() < this.pSetSize || allPresenceItems.size() > this.numItems - this.aSetSize) continue;
                HashSet<Integer> absenceItemSet = new HashSet<Integer>();
                while (absenceItemSet.size() < this.aSetSize) {
                    int absenceItemIdx = Randoms.uniform(this.numItems);
                    if (absenceItemSet.contains(absenceItemIdx) || allPresenceItems.contains(absenceItemIdx)) continue;
                    absenceItemSet.add(absenceItemIdx);
                }
                int allPresenceItemNum = allPresenceItems.size();
                HashSet<Integer> presenceItemSet = new HashSet<Integer>();
                while (presenceItemSet.size() < this.pSetSize) {
                    int presenceItemIdx = allPresenceItems.get(Randoms.uniform(allPresenceItemNum));
                    if (presenceItemSet.contains(presenceItemIdx)) continue;
                    presenceItemSet.add(presenceItemIdx);
                }
                double r_uP = 0.0;
                double[] v_P = new double[this.numFactors];
                Iterator iterator = presenceItemSet.iterator();
                while (iterator.hasNext()) {
                    int pItemIdx = (Integer)iterator.next();
                    r_uP += this.predict(userIdx, pItemIdx);
                    DenseVector itemVec = this.itemFactors.row(pItemIdx);
                    for (int d = 0; d < this.numFactors; ++d) {
                        int n = d;
                        v_P[n] = v_P[n] + itemVec.get(d) / (double)this.pSetSize;
                    }
                }
                r_uP /= (double)this.pSetSize;
                double[] v_A = new double[this.numFactors];
                double r_uA = 0.0;
                Iterator d = absenceItemSet.iterator();
                while (d.hasNext()) {
                    int aItemIdx = (Integer)d.next();
                    r_uA += this.predict(userIdx, aItemIdx);
                    DenseVector itemVec = this.itemFactors.row(aItemIdx);
                    for (int d2 = 0; d2 < this.numFactors; ++d2) {
                        int n = d2;
                        v_A[n] = v_A[n] + itemVec.get(d2) / (double)this.aSetSize;
                    }
                }
                double loss_uAP = -Maths.logistic((r_uA /= (double)this.aSetSize) - r_uP);
                this.loss += -Math.log(Maths.logistic(r_uP - r_uA));
                for (int factorIdx = 0; factorIdx < this.numFactors; ++factorIdx) {
                    double oldFactorValue2 = this.userFactors.get(userIdx, factorIdx);
                    double grad_U_u_f = loss_uAP * (v_P[factorIdx] - v_A[factorIdx]) + (double)this.regUser * oldFactorValue2;
                    this.userFactors.plus(userIdx, factorIdx, (double)(-this.learnRate) * grad_U_u_f);
                    this.loss += (double)this.regUser * oldFactorValue2 * oldFactorValue2;
                }
                Iterator iterator2 = presenceItemSet.iterator();
                while (iterator2.hasNext()) {
                    int pItemIdx = (Integer)iterator2.next();
                    for (int factorIdx = 0; factorIdx < this.numFactors; ++factorIdx) {
                        oldFactorValue = this.itemFactors.get(pItemIdx, factorIdx);
                        double grad_V_i_f = loss_uAP * (this.userFactors.get(userIdx, factorIdx) / (double)this.pSetSize) + (double)this.regItem * oldFactorValue;
                        this.itemFactors.plus(pItemIdx, factorIdx, (double)(-this.learnRate) * grad_V_i_f);
                        this.loss += (double)this.regItem * oldFactorValue * oldFactorValue;
                    }
                    oldBiasValue = this.itemBiases.get(pItemIdx);
                    double grad_biasV_i = loss_uAP / (double)this.pSetSize + this.regBias * oldBiasValue;
                    this.itemBiases.plus(pItemIdx, (double)(-this.learnRate) * grad_biasV_i);
                    this.loss += this.regBias * oldBiasValue * oldBiasValue;
                }
                iterator2 = absenceItemSet.iterator();
                while (iterator2.hasNext()) {
                    int aItemIdx = (Integer)iterator2.next();
                    for (int factorIdx = 0; factorIdx < this.numFactors; ++factorIdx) {
                        oldFactorValue = this.itemFactors.get(aItemIdx, factorIdx);
                        double grad_V_j_f = loss_uAP * (-this.userFactors.get(userIdx, factorIdx) / (double)absenceItemSet.size()) + (double)this.regItem * oldFactorValue;
                        this.itemFactors.set(aItemIdx, factorIdx, (double)(-this.learnRate) * grad_V_j_f);
                        this.loss += (double)this.regItem * oldFactorValue * oldFactorValue;
                    }
                    oldBiasValue = this.itemBiases.get(aItemIdx);
                    double grad_biasV_j = -loss_uAP / (double)this.aSetSize + this.regBias * oldBiasValue;
                    this.itemBiases.plus(aItemIdx, (double)(-this.learnRate) * grad_biasV_j);
                    this.loss += this.regBias * oldBiasValue * oldBiasValue;
                }
            }
            this.loss *= 0.5;
            if (this.isConverged(iter) && this.earlyStop) break;
            this.updateLRate(iter);
        }
    }

    @Override
    protected double predict(int userIdx, int itemIdx) throws LibrecException {
        return super.predict(userIdx, itemIdx) + this.itemBiases.get(itemIdx);
    }
}

