/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.cf.ranking;

import java.util.Arrays;
import java.util.List;
import net.librec.common.LibrecException;
import net.librec.math.algorithm.Maths;
import net.librec.math.structure.DenseMatrix;
import net.librec.math.structure.DenseVector;
import net.librec.math.structure.MatrixEntry;
import net.librec.math.structure.Vector;
import net.librec.math.structure.VectorBasedDenseVector;
import net.librec.recommender.MatrixFactorizationRecommender;
import org.apache.commons.lang.ArrayUtils;

public class ListRankMFRecommender
extends MatrixFactorizationRecommender {
    public VectorBasedDenseVector userExp;

    @Override
    protected void setup() throws LibrecException {
        super.setup();
        this.userFactors.init(1.0);
        this.userFactors.times(0.1);
        this.itemFactors.init(1.0);
        this.itemFactors.times(0.1);
        this.userExp = new VectorBasedDenseVector(this.numUsers);
        for (MatrixEntry matrixentry : this.trainMatrix) {
            int userIdx = matrixentry.row();
            double realRating = matrixentry.get() / this.maxRate;
            this.userExp.plus(userIdx, Math.exp(realRating));
        }
    }

    @Override
    protected void trainModel() throws LibrecException {
        for (int iter = 1; iter <= this.numIterations; ++iter) {
            double tempvalue;
            double prui;
            Object tempvector;
            this.loss = 0.0;
            for (int u = 0; u < this.numUsers; ++u) {
                double uexp = 0.0;
                int[] items = this.trainMatrix.row(u).getIndices();
                DenseVector userEmbed = this.userFactors.row(u);
                for (int itemIdx : items) {
                    DenseVector itemEmbed = this.itemFactors.row(itemIdx);
                    uexp += Math.exp(Maths.logistic(userEmbed.dot(itemEmbed)));
                }
                tempvector = new VectorBasedDenseVector(this.numFactors);
                int[] nArray = items;
                int n = nArray.length;
                for (int itemIdx = 0; itemIdx < n; ++itemIdx) {
                    int itemIdx2 = nArray[itemIdx];
                    DenseVector qj = this.itemFactors.row(itemIdx2);
                    prui = userEmbed.dot(qj);
                    tempvalue = Math.exp(Maths.logistic(prui)) / uexp - Math.exp(this.trainMatrix.get(u, itemIdx2)) / this.userExp.get(u);
                    tempvector = qj.times(Maths.logisticGradientValue(prui) * tempvalue);
                }
                DenseVector denseVector = ((DenseVector)tempvector).plus(userEmbed.times(this.regUser)).times(this.learnRate);
                userEmbed = userEmbed.minus(denseVector);
                this.userFactors.set(u, userEmbed);
            }
            for (int j = 0; j < this.numItems; ++j) {
                double iexp = 0.0;
                int[] users = this.trainMatrix.column(j).getIndices();
                DenseVector itemEmbed = this.itemFactors.row(j);
                for (int userIdx : users) {
                    DenseVector userEmbed = this.userFactors.row(userIdx);
                    iexp += Math.exp(Maths.logistic(itemEmbed.dot(userEmbed)));
                }
                tempvector = new VectorBasedDenseVector(this.numFactors);
                for (int userIdx : users) {
                    DenseVector pu = this.userFactors.row(userIdx);
                    prui = pu.dot(itemEmbed);
                    tempvalue = Math.exp(Maths.logistic(prui)) / iexp - Math.exp(this.trainMatrix.get(userIdx, j)) / this.userExp.get(userIdx);
                    tempvector = pu.times(Maths.logisticGradientValue(prui) * tempvalue);
                }
                DenseVector denseVector = ((DenseVector)tempvector).plus(itemEmbed.times(this.regItem)).times(this.learnRate);
                itemEmbed = itemEmbed.minus(denseVector);
                this.itemFactors.set(j, itemEmbed);
            }
        }
    }

    public double getLoss(DenseMatrix userFactors, DenseMatrix itemFactors) {
        double loss = 0.0;
        for (int userIdx = 0; userIdx < this.numUsers; ++userIdx) {
            double uexp = 0.0;
            int[] itemIndexes = this.trainMatrix.row(userIdx).getIndices();
            Integer[] inputBoxed = ArrayUtils.toObject(itemIndexes);
            List<Integer> items = Arrays.asList(inputBoxed);
            for (int itemIdx : items) {
                uexp += Math.exp(Maths.logistic(userFactors.row(userIdx).dot(itemFactors.row(itemIdx))));
            }
            for (Vector.VectorEntry itemEntry : this.trainMatrix.row(userIdx)) {
                int itemIdx = itemEntry.index();
                double realRating = itemEntry.get() / this.maxRate;
                double predictRating = userFactors.row(userIdx).dot(itemFactors.row(itemIdx));
                loss -= Math.exp(realRating) / this.userExp.get(userIdx) * Math.log(Math.exp(Maths.logistic(predictRating)) / uexp);
            }
            for (int factorIdx = 0; factorIdx < this.numFactors; ++factorIdx) {
                double userFactorValue = userFactors.get(userIdx, factorIdx);
                loss += 0.5 * (double)this.regUser * userFactorValue * userFactorValue;
            }
        }
        for (int itemIdx = 0; itemIdx < this.numItems; ++itemIdx) {
            for (int factorIdx = 0; factorIdx < this.numFactors; ++factorIdx) {
                double itemFactorValue = itemFactors.get(itemIdx, factorIdx);
                loss += 0.5 * (double)this.regItem * itemFactorValue * itemFactorValue;
            }
        }
        return loss;
    }
}

