/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.cf.ranking;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import net.librec.common.LibrecException;
import net.librec.math.algorithm.Randoms;
import net.librec.math.structure.DenseMatrix;
import net.librec.math.structure.MatrixEntry;
import net.librec.math.structure.VectorBasedDenseVector;
import net.librec.recommender.MatrixProbabilisticGraphicalRecommender;

public class PLSARecommender
extends MatrixProbabilisticGraphicalRecommender {
    protected int numTopics;
    protected Table<Integer, Integer, double[]> Q;
    protected DenseMatrix userTopicProbs;
    protected DenseMatrix userTopicProbsSum;
    protected DenseMatrix topicItemProbs;
    protected DenseMatrix topicItemProbsSum;
    private VectorBasedDenseVector topicProbsSum;
    protected VectorBasedDenseVector numItemsRateByUser;

    @Override
    protected void setup() throws LibrecException {
        int userIdx;
        double[] probs;
        super.setup();
        this.numTopics = this.conf.getInt("rec.topic.number", 10);
        this.isRanking = true;
        this.userTopicProbs = new DenseMatrix(this.numUsers, this.numTopics);
        for (int userIdx2 = 0; userIdx2 < this.numUsers; ++userIdx2) {
            probs = Randoms.randProbs(this.numTopics);
            for (int topicIdx = 0; topicIdx < this.numTopics; ++topicIdx) {
                this.userTopicProbs.set(userIdx2, topicIdx, probs[topicIdx]);
            }
        }
        this.topicItemProbs = new DenseMatrix(this.numTopics, this.numItems);
        for (int topicIdx = 0; topicIdx < this.numTopics; ++topicIdx) {
            probs = Randoms.randProbs(this.numItems);
            for (int itemIdx = 0; itemIdx < this.numItems; ++itemIdx) {
                this.topicItemProbs.set(topicIdx, itemIdx, probs[itemIdx]);
            }
        }
        this.Q = HashBasedTable.create();
        for (MatrixEntry matrixEntry : this.trainMatrix) {
            userIdx = matrixEntry.row();
            int itemIdx = matrixEntry.column();
            this.Q.put(userIdx, itemIdx, new double[this.numTopics]);
        }
        this.numItemsRateByUser = new VectorBasedDenseVector(this.numUsers);
        for (MatrixEntry matrixEntry : this.trainMatrix) {
            userIdx = matrixEntry.row();
            this.numItemsRateByUser.plus(userIdx, matrixEntry.get());
        }
    }

    @Override
    protected void eStep() {
        for (MatrixEntry matrixEntry : this.trainMatrix) {
            int topicIdx;
            int userIdx = matrixEntry.row();
            int itemIdx = matrixEntry.column();
            double[] topicDistr = this.Q.get(userIdx, itemIdx);
            double sum2 = 0.0;
            for (topicIdx = 0; topicIdx < this.numTopics; ++topicIdx) {
                double value;
                topicDistr[topicIdx] = value = this.userTopicProbs.get(userIdx, topicIdx) * this.topicItemProbs.get(topicIdx, itemIdx);
                sum2 += value;
            }
            sum2 = sum2 > 0.0 ? sum2 : 1.0;
            topicIdx = 0;
            while (topicIdx < this.numTopics) {
                int n = topicIdx++;
                topicDistr[n] = topicDistr[n] / sum2;
            }
        }
    }

    @Override
    protected void mStep() {
        double value;
        int itemIdx;
        this.userTopicProbsSum = new DenseMatrix(this.numUsers, this.numTopics);
        this.topicItemProbsSum = new DenseMatrix(this.numTopics, this.numItems);
        this.topicProbsSum = new VectorBasedDenseVector(this.numTopics);
        for (MatrixEntry matrixEntry : this.trainMatrix) {
            int userIdx = matrixEntry.row();
            itemIdx = matrixEntry.column();
            double num = matrixEntry.get();
            double[] topicDistr = this.Q.get(userIdx, itemIdx);
            for (int topicIdx = 0; topicIdx < this.numTopics; ++topicIdx) {
                double val = topicDistr[topicIdx] * num;
                this.userTopicProbsSum.plus(userIdx, topicIdx, val);
                this.topicItemProbsSum.plus(topicIdx, itemIdx, val);
                this.topicProbsSum.plus(topicIdx, val);
            }
        }
        for (int userIdx = 0; userIdx < this.numUsers; ++userIdx) {
            double deno = this.numItemsRateByUser.get(userIdx);
            for (int topicIdx = 0; topicIdx < this.numTopics; ++topicIdx) {
                value = deno > 0.0 ? this.userTopicProbsSum.get(userIdx, topicIdx) / this.numItemsRateByUser.get(userIdx) : 0.0;
                this.userTopicProbs.set(userIdx, topicIdx, value);
            }
        }
        for (int topicIdx = 0; topicIdx < this.numTopics; ++topicIdx) {
            double itemTopicProbsSum = this.topicProbsSum.get(topicIdx);
            for (itemIdx = 0; itemIdx < this.numItems; ++itemIdx) {
                value = itemTopicProbsSum > 0.0 ? this.topicItemProbsSum.get(topicIdx, itemIdx) / itemTopicProbsSum : 0.0;
                this.topicItemProbs.set(topicIdx, itemIdx, value);
            }
        }
    }

    @Override
    protected double predict(int userIdx, int itemIdx) throws LibrecException {
        return this.userTopicProbs.row(userIdx).dot(this.topicItemProbs.column(itemIdx));
    }
}

