/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.cf.ranking;

import java.util.Date;
import net.librec.common.LibrecException;
import net.librec.math.structure.DenseMatrix;
import net.librec.math.structure.DenseVector;
import net.librec.math.structure.MatrixEntry;
import net.librec.math.structure.SequentialAccessSparseMatrix;
import net.librec.math.structure.SequentialSparseVector;
import net.librec.math.structure.VectorBasedDenseVector;
import net.librec.recommender.MatrixFactorizationRecommender;

public class RankPMFRecommender
extends MatrixFactorizationRecommender {
    private double aMinusb;
    private SequentialAccessSparseMatrix preferenceMatrix;

    @Override
    protected void setup() throws LibrecException {
        super.setup();
        this.aMinusb = this.conf.getFloat("rec.confidence.a").floatValue() - this.conf.getFloat("rec.confidence.b").floatValue();
        this.preferenceMatrix = new SequentialAccessSparseMatrix(this.trainMatrix);
        for (MatrixEntry matrixEntry : this.preferenceMatrix) {
            matrixEntry.set(1.0);
        }
    }

    @Override
    protected void trainModel() throws LibrecException {
        DenseMatrix userIdentityMatrix = this.BuildEyeMatrix(this.numFactors).times(this.regUser);
        DenseMatrix itemIdentityMatrix = this.BuildEyeMatrix(this.numFactors).times(this.regItem);
        DenseMatrix X = this.userFactors;
        DenseMatrix Y = this.itemFactors;
        for (int iter = 1; iter <= this.numIterations; ++iter) {
            int itemIdx;
            int n;
            DenseMatrix Yt = Y.transpose();
            DenseMatrix YtY = Yt.times(Y);
            for (int userIdx = 0; userIdx < this.numUsers; ++userIdx) {
                int[] itemList;
                DenseMatrix YtCuI = new DenseMatrix(this.numFactors, this.numItems);
                SequentialSparseVector userRatingVec = this.trainMatrix.row(userIdx);
                for (int itemIdx2 : itemList = userRatingVec.getIndices()) {
                    for (int factorIdx = 0; factorIdx < this.numFactors; ++factorIdx) {
                        YtCuI.set(factorIdx, itemIdx2, Y.get(itemIdx2, factorIdx) * this.aMinusb);
                    }
                }
                DenseMatrix YtCuY = new DenseMatrix(this.numFactors, this.numFactors);
                for (int factorIdx = 0; factorIdx < this.numFactors; ++factorIdx) {
                    for (int factorIdxIn = 0; factorIdxIn < this.numFactors; ++factorIdxIn) {
                        double value = 0.0;
                        int[] nArray = itemList;
                        int n2 = nArray.length;
                        for (n = 0; n < n2; ++n) {
                            itemIdx = nArray[n];
                            value += YtCuI.get(factorIdx, itemIdx) * Y.get(itemIdx, factorIdxIn);
                        }
                        YtCuY.set(factorIdx, factorIdxIn, value);
                    }
                }
                YtCuY = YtCuY.plus(YtY);
                Object Wu = YtCuY.plus(userIdentityMatrix).inverse();
                VectorBasedDenseVector YtCuPu = new VectorBasedDenseVector(this.numFactors);
                for (int factorIdx = 0; factorIdx < this.numFactors; ++factorIdx) {
                    for (int itemIdx3 : itemList) {
                        YtCuPu.plus(factorIdx, YtCuI.get(factorIdx, itemIdx3) + Yt.get(factorIdx, itemIdx3));
                    }
                }
                DenseVector xu = ((DenseMatrix)Wu).times(YtCuPu);
                X.set(userIdx, xu);
            }
            DenseMatrix Xt = X.transpose();
            DenseMatrix XtX = Xt.times(X);
            for (int itemIdx4 = 0; itemIdx4 < this.numItems; ++itemIdx4) {
                DenseMatrix XtCiI = new DenseMatrix(this.numFactors, this.numUsers);
                int[] userList = this.trainMatrix.column(itemIdx4).getIndices();
                for (int userIdx : userList) {
                    for (int factorIdx = 0; factorIdx < this.numFactors; ++factorIdx) {
                        XtCiI.set(factorIdx, userIdx, X.get(userIdx, factorIdx) * this.aMinusb);
                    }
                }
                DenseMatrix XtCiX = new DenseMatrix(this.numFactors, this.numFactors);
                for (int factorIdx = 0; factorIdx < this.numFactors; ++factorIdx) {
                    for (int factorIdxIn = 0; factorIdxIn < this.numFactors; ++factorIdxIn) {
                        double value = 0.0;
                        int[] nArray = userList;
                        n = nArray.length;
                        for (itemIdx = 0; itemIdx < n; ++itemIdx) {
                            int userIdx = nArray[itemIdx];
                            value += XtCiI.get(factorIdx, userIdx) * X.get(userIdx, factorIdxIn);
                        }
                        XtCiX.set(factorIdx, factorIdxIn, value);
                    }
                }
                XtCiX = XtCiX.plus(XtX);
                DenseMatrix Wi = XtCiX.plus(itemIdentityMatrix).inverse();
                VectorBasedDenseVector XtCiPu = new VectorBasedDenseVector(this.numFactors);
                for (int factorIdx = 0; factorIdx < this.numFactors; ++factorIdx) {
                    int[] nArray = userList;
                    int n3 = nArray.length;
                    for (n = 0; n < n3; ++n) {
                        int userIdx = nArray[n];
                        XtCiPu.plus(factorIdx, XtCiI.get(factorIdx, userIdx) + Xt.get(factorIdx, userIdx));
                    }
                }
                DenseVector yi = Wi.times(XtCiPu);
                Y.set(itemIdx4, yi);
            }
            if (!verbose) continue;
            this.LOG.info(this.getClass() + " runs at iteration = " + iter + " " + new Date());
        }
    }

    protected DenseMatrix BuildEyeMatrix(int numDim) throws LibrecException {
        double[][] values = new double[numDim][numDim];
        for (int i = 0; i < numDim; ++i) {
            values[i][i] = 1.0;
        }
        return new DenseMatrix(values);
    }
}

