/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.cf.rating;

import net.librec.annotation.ModelData;
import net.librec.common.LibrecException;
import net.librec.math.structure.MatrixEntry;
import net.librec.math.structure.VectorBasedDenseVector;
import net.librec.recommender.MatrixFactorizationRecommender;

@ModelData(value={"isRating", "biasedMF", "userFactors", "itemFactors", "userBiases", "itemBiases"})
public class BiasedMFRecommender
extends MatrixFactorizationRecommender {
    protected double regBias;
    protected VectorBasedDenseVector userBiases;
    protected VectorBasedDenseVector itemBiases;

    @Override
    protected void setup() throws LibrecException {
        super.setup();
        this.regBias = this.conf.getDouble("rec.bias.regularization", 0.01);
        this.userBiases = new VectorBasedDenseVector(this.numUsers);
        this.itemBiases = new VectorBasedDenseVector(this.numItems);
        this.userBiases.init(this.initMean, this.initStd);
        this.itemBiases.init(this.initMean, this.initStd);
    }

    @Override
    protected void trainModel() throws LibrecException {
        for (int iter = 1; iter <= this.numIterations; ++iter) {
            this.loss = 0.0;
            for (MatrixEntry matrixEntry : this.trainMatrix) {
                int userIdx = matrixEntry.row();
                int itemIdx = matrixEntry.column();
                double realRating = matrixEntry.get();
                double predictRating = this.predict(userIdx, itemIdx);
                double error = realRating - predictRating;
                this.loss += error * error;
                double userBiasValue = this.userBiases.get(userIdx);
                this.userBiases.plus(userIdx, (double)this.learnRate * (error - this.regBias * userBiasValue));
                this.loss += this.regBias * userBiasValue * userBiasValue;
                double itemBiasValue = this.itemBiases.get(itemIdx);
                this.itemBiases.plus(itemIdx, (double)this.learnRate * (error - this.regBias * itemBiasValue));
                this.loss += this.regBias * itemBiasValue * itemBiasValue;
                for (int factorIdx = 0; factorIdx < this.numFactors; ++factorIdx) {
                    double userFactorValue = this.userFactors.get(userIdx, factorIdx);
                    double itemFactorValue = this.itemFactors.get(itemIdx, factorIdx);
                    this.userFactors.plus(userIdx, factorIdx, (double)this.learnRate * (error * itemFactorValue - (double)this.regUser * userFactorValue));
                    this.itemFactors.plus(itemIdx, factorIdx, (double)this.learnRate * (error * userFactorValue - (double)this.regItem * itemFactorValue));
                    this.loss += (double)this.regUser * userFactorValue * userFactorValue + (double)this.regItem * itemFactorValue * itemFactorValue;
                }
            }
            this.loss *= 0.5;
            if (this.isConverged(iter) && this.earlyStop) break;
            this.updateLRate(iter);
        }
    }

    @Override
    protected double predict(int userIdx, int itemIdx) throws LibrecException {
        return this.userFactors.row(userIdx).dot(this.itemFactors.row(itemIdx)) + this.userBiases.get(userIdx) + this.itemBiases.get(itemIdx) + this.globalMean;
    }
}

