/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.cf.rating;

import net.librec.math.algorithm.Randoms;
import net.librec.math.structure.DenseMatrix;
import net.librec.math.structure.DenseVector;
import net.librec.math.structure.MatrixEntry;
import net.librec.math.structure.SequentialAccessSparseMatrix;

public class LLORMAUpdater
extends Thread {
    private int threadId;
    private int numFactors;
    private int numUsers;
    private int numItems;
    private int anchorUser;
    private int anchorItem;
    public double learnRate;
    public int localIteration;
    public double localRegUser;
    public double localRegItem;
    private DenseVector userWeights;
    private DenseVector itemWeights;
    private DenseMatrix localUserFactors;
    private DenseMatrix localItemFactors;
    private SequentialAccessSparseMatrix trainMatrix;

    public LLORMAUpdater(int threadIDParam, int numFactorsParam, int numUsersParam, int numItemsParam, int anchorUserParam, int anchorItemParam, double learnRateParam, double localRegUserParam, double localRegItemParam, int localIterationParam, DenseVector userWeightsParam, DenseVector itemWeightsParam, SequentialAccessSparseMatrix trainMatrixParam) {
        this.threadId = threadIDParam;
        this.numFactors = numFactorsParam;
        this.numUsers = numUsersParam;
        this.numItems = numItemsParam;
        this.anchorUser = anchorUserParam;
        this.anchorItem = anchorItemParam;
        this.learnRate = learnRateParam;
        this.localRegUser = localRegUserParam;
        this.localRegItem = localRegItemParam;
        this.localIteration = localIterationParam;
        this.userWeights = userWeightsParam;
        this.itemWeights = itemWeightsParam;
        this.localUserFactors = new DenseMatrix(this.numUsers, this.numFactors);
        this.localItemFactors = new DenseMatrix(this.numItems, this.numFactors);
        this.trainMatrix = trainMatrixParam;
    }

    public int getThreadId() {
        return this.threadId;
    }

    public int getRank() {
        return this.numFactors;
    }

    public int getUserAnchor() {
        return this.anchorUser;
    }

    public int getItemAnchor() {
        return this.anchorItem;
    }

    public DenseMatrix getLocalUserFactors() {
        return this.localUserFactors;
    }

    public DenseMatrix getLocalItemFactors() {
        return this.localItemFactors;
    }

    @Override
    public void run() {
        double rdm;
        int factorIdx;
        for (int userIdx = 0; userIdx < this.numUsers; ++userIdx) {
            for (factorIdx = 0; factorIdx < this.numFactors; ++factorIdx) {
                rdm = Randoms.gaussian(0.0, 0.01);
                this.localUserFactors.set(userIdx, factorIdx, rdm);
            }
        }
        for (int itemIdx = 0; itemIdx < this.numItems; ++itemIdx) {
            for (factorIdx = 0; factorIdx < this.numFactors; ++factorIdx) {
                rdm = Randoms.gaussian(0.0, 0.01);
                this.localItemFactors.set(itemIdx, factorIdx, rdm);
            }
        }
        for (int iter = 0; iter < this.localIteration; ++iter) {
            for (MatrixEntry matrixEntry : this.trainMatrix) {
                int userIdx = matrixEntry.row();
                int itemIdx = matrixEntry.column();
                double rating = matrixEntry.get();
                double predictRating = this.predict(userIdx, itemIdx);
                double error = rating - predictRating;
                double weight = this.userWeights.get(userIdx) * this.itemWeights.get(itemIdx);
                for (int factorIdx2 = 0; factorIdx2 < this.numFactors; ++factorIdx2) {
                    double userFactorValue = this.localUserFactors.get(userIdx, factorIdx2);
                    double itemFactorValue = this.localItemFactors.get(itemIdx, factorIdx2);
                    this.localUserFactors.plus(userIdx, factorIdx2, this.learnRate * (error * itemFactorValue * weight - this.localRegUser * userFactorValue));
                    this.localItemFactors.plus(itemIdx, factorIdx2, this.learnRate * (error * userFactorValue * weight - this.localRegItem * itemFactorValue));
                }
            }
        }
    }

    protected double predict(int userIdx, int itemIdx) {
        return this.localUserFactors.row(userIdx).dot(this.localItemFactors.row(itemIdx));
    }
}

