/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.cf.rating;

import net.librec.annotation.ModelData;
import net.librec.common.LibrecException;
import net.librec.math.structure.DenseMatrix;
import net.librec.math.structure.SequentialSparseVector;
import net.librec.math.structure.Vector;
import net.librec.math.structure.VectorBasedDenseVector;
import net.librec.recommender.MatrixFactorizationRecommender;

@ModelData(value={"isRating", "biasedMF", "userFactors", "itemFactors"})
public class MFALSRecommender
extends MatrixFactorizationRecommender {
    @Override
    protected void trainModel() throws LibrecException {
        DenseMatrix identify = this.BuildEyeMatrix(this.numFactors);
        for (int iter = 1; iter <= this.numIterations; ++iter) {
            Object A;
            double rating;
            int index;
            for (int userIdx = 0; userIdx < this.numUsers; ++userIdx) {
                SequentialSparseVector userRatingVec = this.trainMatrix.row(userIdx);
                int numItemOfUser = userRatingVec.size();
                DenseMatrix M = new DenseMatrix(numItemOfUser, this.numFactors);
                VectorBasedDenseVector uservector = new VectorBasedDenseVector(numItemOfUser);
                index = 0;
                for (Vector.VectorEntry ve : userRatingVec) {
                    int itemIdx = ve.index();
                    rating = ve.get();
                    M.set(index, this.itemFactors.row(itemIdx));
                    uservector.set(index, rating);
                    ++index;
                }
                A = M.transpose().times(M).plus(identify.times(this.regUser).times(numItemOfUser));
                this.userFactors.set(userIdx, ((DenseMatrix)A).inverse().times(M.transpose().times(uservector)));
            }
            for (int itemIdx = 0; itemIdx < this.numItems; ++itemIdx) {
                SequentialSparseVector itemRatingVec = this.trainMatrix.column(itemIdx);
                int numusers = itemRatingVec.size();
                DenseMatrix U = new DenseMatrix(numusers, this.numFactors);
                VectorBasedDenseVector itemvector = new VectorBasedDenseVector(numusers);
                index = 0;
                for (Vector.VectorEntry ve : itemRatingVec) {
                    int userIdx = ve.index();
                    rating = ve.get();
                    U.set(index, this.userFactors.row(userIdx));
                    itemvector.set(index, rating);
                    ++index;
                }
                A = U.transpose().times(U).plus(identify.times(this.regItem).times(numusers));
                this.itemFactors.set(itemIdx, ((DenseMatrix)A).inverse().times(U.transpose().times(itemvector)));
            }
        }
    }

    protected DenseMatrix BuildEyeMatrix(int numDim) throws LibrecException {
        double[][] values = new double[numDim][numDim];
        for (int i = 0; i < numDim; ++i) {
            values[i][i] = 1.0;
        }
        return new DenseMatrix(values);
    }
}

